/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.util;

import org.eclipse.smarthome.config.xml.util.NodeName;

public class NodeValue
implements NodeName {
    private String nodeName;
    private Object value;

    public NodeValue(String nodeName, Object value) throws IllegalArgumentException {
        if (nodeName == null || nodeName.isEmpty()) {
            throw new IllegalArgumentException("The name of the node must neither be null nor empty!");
        }
        this.nodeName = nodeName;
        this.value = this.formatText(value);
    }

    private Object formatText(Object object) {
        if (object instanceof String) {
            return ((String)object).replaceAll("\\n\\s*", " ").trim();
        }
        return object;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "NodeValue [nodeName=" + this.nodeName + ", value=" + this.value + "]";
    }
}

