/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.binding.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.GenericUnmarshaller;
import org.eclipse.smarthome.config.xml.util.NodeIterator;
import org.eclipse.smarthome.core.binding.xml.internal.BindingInfoImpl;
import org.eclipse.smarthome.core.binding.xml.internal.BindingInfoXmlResult;

public class BindingInfoConverter
extends GenericUnmarshaller<BindingInfoXmlResult> {
    private ConverterAttributeMapValidator attributeMapValidator = new ConverterAttributeMapValidator((String[][])new String[][]{{"id", "true"}, {"schemaLocation", "false"}});

    public BindingInfoConverter() {
        super(BindingInfoXmlResult.class);
    }

    private URI readConfigDescriptionURI(NodeIterator nodeIterator) throws ConversionException {
        String uriText = nodeIterator.nextAttribute("config-description-ref", "uri", false);
        if (uriText != null) {
            try {
                return new URI(uriText);
            }
            catch (NullPointerException | URISyntaxException ex) {
                throw new ConversionException("The URI '" + uriText + "' in node " + "'config-description-ref' is invalid!", (Throwable)ex);
            }
        }
        return null;
    }

    private ConfigDescription readConfigDescription(NodeIterator nodeIterator) {
        Object nextNode = nodeIterator.next();
        if (nextNode != null) {
            if (nextNode instanceof ConfigDescription) {
                return (ConfigDescription)nextNode;
            }
            nodeIterator.revert();
        }
        return null;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        BindingInfoXmlResult bindingInfoXmlResult = null;
        BindingInfoImpl bindingInfo = null;
        Map attributes = this.attributeMapValidator.readValidatedAttributes(reader);
        String id = (String)attributes.get("id");
        context.put((Object)"config-description.uri", (Object)("binding:" + id));
        List nodes = (List)context.convertAnother((Object)context, List.class);
        NodeIterator nodeIterator = new NodeIterator(nodes);
        String name = (String)nodeIterator.nextValue("name", true);
        String description = (String)nodeIterator.nextValue("description", false);
        String author = (String)nodeIterator.nextValue("author", true);
        URI configDescriptionURI = this.readConfigDescriptionURI(nodeIterator);
        ConfigDescription configDescription = null;
        if (configDescriptionURI == null && (configDescription = this.readConfigDescription(nodeIterator)) != null) {
            configDescriptionURI = configDescription.getURI();
        }
        nodeIterator.assertEndOfType();
        bindingInfo = new BindingInfoImpl(id, name, description, author, configDescriptionURI);
        bindingInfoXmlResult = new BindingInfoXmlResult(bindingInfo, configDescription);
        return bindingInfoXmlResult;
    }
}

