/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.binding.xml.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.XmlConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.core.binding.BindingInfo;
import org.eclipse.smarthome.core.binding.xml.internal.BindingInfoXmlResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingInfoXmlProvider
implements XmlDocumentProvider<BindingInfoXmlResult> {
    private Logger logger = LoggerFactory.getLogger(BindingInfoXmlProvider.class);
    private BundleContext bundleContext;
    private Bundle bundle;
    private XmlConfigDescriptionProvider configDescriptionProvider;
    private List<ServiceRegistration<?>> serviceRegistrationList;

    public BindingInfoXmlProvider(BundleContext bundleContext, Bundle bundle, XmlConfigDescriptionProvider configDescriptionProvider) throws IllegalArgumentException {
        if (bundleContext == null) {
            throw new IllegalArgumentException("The BundleContext must not be null!");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("The Bundle must not be null!");
        }
        if (configDescriptionProvider == null) {
            throw new IllegalArgumentException("The XmlConfigDescriptionProvider must not be null!");
        }
        this.bundleContext = bundleContext;
        this.bundle = bundle;
        this.configDescriptionProvider = configDescriptionProvider;
        this.serviceRegistrationList = new ArrayList(10);
    }

    public synchronized void addingObject(BindingInfoXmlResult bindingInfoXmlResult) {
        if (bindingInfoXmlResult != null) {
            ConfigDescription configDescription = bindingInfoXmlResult.getConfigDescription();
            if (configDescription != null) {
                try {
                    this.configDescriptionProvider.addConfigDescription(this.bundle, configDescription);
                }
                catch (Exception ex) {
                    this.logger.error("Could not register ConfigDescription!", (Throwable)ex);
                }
            }
            try {
                BindingInfo bindingInfo = bindingInfoXmlResult.getBindingInfo();
                ServiceRegistration bindingInfoReg = this.bundleContext.registerService(BindingInfo.class.getName(), (Object)bindingInfo, null);
                this.serviceRegistrationList.add(bindingInfoReg);
            }
            catch (Exception ex) {
                this.logger.error("Could not register BindingInfo!", (Throwable)ex);
            }
        }
    }

    public void addingFinished() {
    }

    public synchronized void release() {
        int index = this.serviceRegistrationList.size() - 1;
        while (index >= 0) {
            try {
                ServiceRegistration<?> bindingInfoReg = this.serviceRegistrationList.get(index);
                bindingInfoReg.unregister();
            }
            catch (Exception ex) {
                this.logger.error("Could not unregister BindingInfo!", (Throwable)ex);
            }
            --index;
        }
        this.serviceRegistrationList.clear();
        this.configDescriptionProvider.removeAllConfigDescriptions(this.bundle);
    }
}

