/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StopMoveType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public class RollershutterItem
extends GenericItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(UnDefType.class);
        acceptedDataTypes.add(UpDownType.class);
        acceptedDataTypes.add(PercentType.class);
        acceptedCommandTypes.add(UpDownType.class);
        acceptedCommandTypes.add(StopMoveType.class);
        acceptedCommandTypes.add(PercentType.class);
        acceptedCommandTypes.add(RefreshType.class);
    }

    public RollershutterItem(String name) {
        super("Rollershutter", name);
    }

    public List<Class<? extends State>> getAcceptedDataTypes() {
        return acceptedDataTypes;
    }

    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return acceptedCommandTypes;
    }

    public void send(UpDownType command) {
        this.internalSend(command);
    }

    public void send(StopMoveType command) {
        this.internalSend(command);
    }

    public void send(PercentType command) {
        this.internalSend(command);
    }

    public void setState(State state) {
        if (state == UpDownType.UP) {
            super.setState((State)PercentType.ZERO);
        } else if (state == UpDownType.DOWN) {
            super.setState((State)PercentType.HUNDRED);
        } else {
            super.setState(state);
        }
    }

    public State getStateAs(Class<? extends State> typeClass) {
        if (typeClass == UpDownType.class) {
            if (this.state.equals(PercentType.ZERO)) {
                return UpDownType.UP;
            }
            if (this.state.equals(PercentType.HUNDRED)) {
                return UpDownType.DOWN;
            }
            return UnDefType.UNDEF;
        }
        if (typeClass == DecimalType.class && this.state instanceof PercentType) {
            return new DecimalType(((PercentType)this.state).toBigDecimal().divide(new BigDecimal(100), 8, RoundingMode.UP));
        }
        return super.getStateAs(typeClass);
    }
}

