/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public class SwitchItem
extends GenericItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(OnOffType.class);
        acceptedDataTypes.add(UnDefType.class);
        acceptedCommandTypes.add(OnOffType.class);
        acceptedCommandTypes.add(RefreshType.class);
    }

    public SwitchItem(String name) {
        super("Switch", name);
    }

    SwitchItem(String type, String name) {
        super(type, name);
    }

    public void send(OnOffType command) {
        this.internalSend(command);
    }

    public List<Class<? extends State>> getAcceptedDataTypes() {
        return acceptedDataTypes;
    }

    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return acceptedCommandTypes;
    }

    public State getStateAs(Class<? extends State> typeClass) {
        if (typeClass == DecimalType.class) {
            return this.state == OnOffType.ON ? new DecimalType(1L) : DecimalType.ZERO;
        }
        if (typeClass == PercentType.class) {
            return this.state == OnOffType.ON ? PercentType.HUNDRED : PercentType.ZERO;
        }
        return super.getStateAs(typeClass);
    }
}

