/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public interface ArithmeticGroupFunction
extends GroupFunction {

    public static class And
    implements GroupFunction {
        protected final State activeState;
        protected final State passiveState;

        public And(State activeValue, State passiveValue) {
            if (activeValue == null || passiveValue == null) {
                throw new IllegalArgumentException("Parameters must not be null!");
            }
            this.activeState = activeValue;
            this.passiveState = passiveValue;
        }

        public State calculate(List<Item> items) {
            if (items != null && items.size() > 0) {
                for (Item item : items) {
                    if (this.activeState.equals(item.getState())) continue;
                    return this.passiveState;
                }
                return this.activeState;
            }
            return this.passiveState;
        }

        public State getStateAs(List<Item> items, Class<? extends State> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return state;
            }
            if (stateClass == DecimalType.class) {
                if (items != null) {
                    return new DecimalType(items.size() - this.count(items, this.activeState));
                }
                return DecimalType.ZERO;
            }
            return null;
        }

        private int count(List<Item> items, State state) {
            int count = 0;
            if (items != null && state != null) {
                for (Item item : items) {
                    if (!state.equals(item.getStateAs(state.getClass()))) continue;
                    ++count;
                }
            }
            return count;
        }
    }

    public static class Avg
    implements GroupFunction {
        public State calculate(List<Item> items) {
            BigDecimal sum = BigDecimal.ZERO;
            int count = 0;
            if (items != null) {
                for (Item item : items) {
                    DecimalType itemState = (DecimalType)item.getStateAs(DecimalType.class);
                    if (itemState == null) continue;
                    sum = sum.add(itemState.toBigDecimal());
                    ++count;
                }
            }
            if (count > 0) {
                return new DecimalType(sum.divide(new BigDecimal(count), RoundingMode.HALF_UP));
            }
            return UnDefType.UNDEF;
        }

        public State getStateAs(List<Item> items, Class<? extends State> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return state;
            }
            return null;
        }
    }

    public static class Max
    implements GroupFunction {
        public State calculate(List<Item> items) {
            if (items != null && items.size() > 0) {
                BigDecimal max = null;
                for (Item item : items) {
                    DecimalType itemState = (DecimalType)item.getStateAs(DecimalType.class);
                    if (itemState == null || max != null && max.compareTo(itemState.toBigDecimal()) >= 0) continue;
                    max = itemState.toBigDecimal();
                }
                if (max != null) {
                    return new DecimalType(max);
                }
            }
            return UnDefType.UNDEF;
        }

        public State getStateAs(List<Item> items, Class<? extends State> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return state;
            }
            return null;
        }
    }

    public static class Min
    implements GroupFunction {
        public State calculate(List<Item> items) {
            if (items != null && items.size() > 0) {
                BigDecimal min = null;
                for (Item item : items) {
                    DecimalType itemState = (DecimalType)item.getStateAs(DecimalType.class);
                    if (itemState == null || min != null && min.compareTo(itemState.toBigDecimal()) <= 0) continue;
                    min = itemState.toBigDecimal();
                }
                if (min != null) {
                    return new DecimalType(min);
                }
            }
            return UnDefType.UNDEF;
        }

        public State getStateAs(List<Item> items, Class<? extends State> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return state;
            }
            return null;
        }
    }

    public static class NAnd
    extends And {
        public NAnd(State activeValue, State passiveValue) {
            super(activeValue, passiveValue);
        }

        @Override
        public State calculate(List<Item> items) {
            State result = super.calculate(items);
            State notResult = result.equals(this.activeState) ? this.passiveState : this.activeState;
            return notResult;
        }
    }

    public static class NOr
    extends Or {
        public NOr(State activeValue, State passiveValue) {
            super(activeValue, passiveValue);
        }

        @Override
        public State calculate(List<Item> items) {
            State result = super.calculate(items);
            State notResult = result.equals(this.activeState) ? this.passiveState : this.activeState;
            return notResult;
        }
    }

    public static class Or
    implements GroupFunction {
        protected final State activeState;
        protected final State passiveState;

        public Or(State activeValue, State passiveValue) {
            if (activeValue == null || passiveValue == null) {
                throw new IllegalArgumentException("Parameters must not be null!");
            }
            this.activeState = activeValue;
            this.passiveState = passiveValue;
        }

        public State calculate(List<Item> items) {
            if (items != null) {
                for (Item item : items) {
                    if (!this.activeState.equals(item.getState())) continue;
                    return this.activeState;
                }
            }
            return this.passiveState;
        }

        public State getStateAs(List<Item> items, Class<? extends State> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return state;
            }
            if (stateClass == DecimalType.class) {
                return new DecimalType(this.count(items, this.activeState));
            }
            return null;
        }

        private int count(List<Item> items, State state) {
            int count = 0;
            if (items != null && state != null) {
                for (Item item : items) {
                    if (!state.equals(item.getStateAs(state.getClass()))) continue;
                    ++count;
                }
            }
            return count;
        }
    }

    public static class Sum
    implements GroupFunction {
        public State calculate(List<Item> items) {
            BigDecimal sum = BigDecimal.ZERO;
            if (items != null) {
                for (Item item : items) {
                    DecimalType itemState = (DecimalType)item.getStateAs(DecimalType.class);
                    if (itemState == null) continue;
                    sum = sum.add(itemState.toBigDecimal());
                }
            }
            return new DecimalType(sum);
        }

        public State getStateAs(List<Item> items, Class<? extends State> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return state;
            }
            return null;
        }
    }
}

