/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.GenericUnmarshaller;
import org.eclipse.smarthome.config.xml.util.NodeIterator;

public abstract class AbstractDescriptionTypeConverter<T>
extends GenericUnmarshaller<T> {
    private ConverterAttributeMapValidator attributeMapValidator;
    private String type;

    public AbstractDescriptionTypeConverter(Class<T> clazz, String type) {
        super(clazz);
        this.type = type;
        this.attributeMapValidator = new ConverterAttributeMapValidator((String[][])new String[][]{{"id", "true"}});
    }

    protected String getID(Map<String, String> attributes) {
        return attributes.get("id");
    }

    protected String getUID(Map<String, String> attributes, UnmarshallingContext context) {
        String bindingId = (String)context.get((Object)"thing-descriptions.bindingId");
        String typeId = this.getID(attributes);
        String uid = String.format("%s:%s", bindingId, typeId);
        return uid;
    }

    protected String readLabel(NodeIterator nodeIterator) throws ConversionException {
        return (String)nodeIterator.nextValue("label", true);
    }

    protected String readDescription(NodeIterator nodeIterator) {
        return (String)nodeIterator.nextValue("description", false);
    }

    private URI readConfigDescriptionURI(NodeIterator nodeIterator) throws ConversionException {
        String uriText = nodeIterator.nextAttribute("config-description-ref", "uri", false);
        if (uriText != null) {
            try {
                return new URI(uriText);
            }
            catch (NullPointerException | URISyntaxException ex) {
                throw new ConversionException("The URI '" + uriText + "' in node " + "'config-description-ref' is invalid!", (Throwable)ex);
            }
        }
        return null;
    }

    private ConfigDescription readConfigDescription(NodeIterator nodeIterator) {
        Object nextNode = nodeIterator.next();
        if (nextNode != null) {
            if (nextNode instanceof ConfigDescription) {
                return (ConfigDescription)nextNode;
            }
            nodeIterator.revert();
        }
        return null;
    }

    protected Object[] getConfigDescriptionObjects(NodeIterator nodeIterator) {
        URI configDescriptionURI = this.readConfigDescriptionURI(nodeIterator);
        ConfigDescription configDescription = null;
        if (configDescriptionURI == null && (configDescription = this.readConfigDescription(nodeIterator)) != null) {
            configDescriptionURI = configDescription.getURI();
        }
        return new Object[]{configDescriptionURI, configDescription};
    }

    protected abstract T unmarshalType(HierarchicalStreamReader var1, UnmarshallingContext var2, Map<String, String> var3, NodeIterator var4) throws ConversionException;

    public final Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Map attributes = this.attributeMapValidator.readValidatedAttributes(reader);
        context.put((Object)"config-description.uri", (Object)(String.valueOf(this.type) + ":" + this.getUID(attributes, context)));
        List nodes = (List)context.convertAnother((Object)context, List.class);
        NodeIterator nodeIterator = new NodeIterator(nodes);
        T object = this.unmarshalType(reader, context, attributes, nodeIterator);
        nodeIterator.assertEndOfType();
        return object;
    }
}

