/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.net.URI;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.util.NodeIterator;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.xml.internal.AbstractDescriptionTypeConverter;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelTypeXmlResult;

public class ChannelTypeConverter
extends AbstractDescriptionTypeConverter<ChannelTypeXmlResult> {
    public ChannelTypeConverter() {
        super(ChannelTypeXmlResult.class, "channel-type");
    }

    private String readItemType(NodeIterator nodeIterator) throws ConversionException {
        return (String)nodeIterator.nextValue("item-type", true);
    }

    @Override
    protected ChannelTypeXmlResult unmarshalType(HierarchicalStreamReader reader, UnmarshallingContext context, Map<String, String> attributes, NodeIterator nodeIterator) throws ConversionException {
        ChannelTypeUID channelTypeUID = new ChannelTypeUID(super.getUID(attributes, context));
        String itemType = this.readItemType(nodeIterator);
        String label = super.readLabel(nodeIterator);
        String description = super.readDescription(nodeIterator);
        Object[] configDescriptionObjects = super.getConfigDescriptionObjects(nodeIterator);
        ChannelType channelType = new ChannelType(channelTypeUID, itemType, label, description, (URI)configDescriptionObjects[0]);
        ChannelTypeXmlResult channelTypeXmlResult = new ChannelTypeXmlResult(channelType, (ConfigDescription)configDescriptionObjects[1]);
        return channelTypeXmlResult;
    }
}

