/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.XmlConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.ThingTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.XmlThingTypeProvider;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingTypeXmlProvider
implements XmlDocumentProvider<List<?>> {
    private Logger logger = LoggerFactory.getLogger(ThingTypeXmlProvider.class);
    private Bundle bundle;
    private XmlConfigDescriptionProvider configDescriptionProvider;
    private XmlThingTypeProvider thingTypeProvider;
    private List<ThingTypeXmlResult> thingTypes;
    private Map<String, ChannelType> channelTypes;

    public ThingTypeXmlProvider(Bundle bundle, XmlConfigDescriptionProvider configDescriptionProvider, XmlThingTypeProvider thingTypeProvider) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("The Bundle must not be null!");
        }
        if (configDescriptionProvider == null) {
            throw new IllegalArgumentException("The XmlConfigDescriptionProvider must not be null!");
        }
        if (thingTypeProvider == null) {
            throw new IllegalArgumentException("The XmlThingTypeProvider must not be null!");
        }
        this.bundle = bundle;
        this.configDescriptionProvider = configDescriptionProvider;
        this.thingTypeProvider = thingTypeProvider;
        this.thingTypes = new ArrayList<ThingTypeXmlResult>(10);
        this.channelTypes = new HashMap<String, ChannelType>(10);
    }

    public synchronized void addingObject(List<?> types) {
        if (types != null) {
            for (Object type : types) {
                Object typeResult;
                if (type instanceof ThingTypeXmlResult) {
                    typeResult = (ThingTypeXmlResult)type;
                    this.addConfigDescription(((ThingTypeXmlResult)typeResult).getConfigDescription());
                    this.thingTypes.add((ThingTypeXmlResult)typeResult);
                    continue;
                }
                if (type instanceof ChannelTypeXmlResult) {
                    typeResult = (ChannelTypeXmlResult)type;
                    this.addConfigDescription(((ChannelTypeXmlResult)typeResult).getConfigDescription());
                    ChannelType channelType = ((ChannelTypeXmlResult)typeResult).getChannelType();
                    this.channelTypes.put(channelType.getUID().toString(), channelType);
                    continue;
                }
                throw new ConversionException("Unknown data type for '" + type + "'!");
            }
        }
    }

    private void addConfigDescription(ConfigDescription configDescription) {
        if (configDescription != null) {
            try {
                this.configDescriptionProvider.addConfigDescription(this.bundle, configDescription);
            }
            catch (Exception ex) {
                this.logger.error("Could not register ConfigDescription!", (Throwable)ex);
            }
        }
    }

    public synchronized void addingFinished() {
        for (ThingTypeXmlResult type : this.thingTypes) {
            this.thingTypeProvider.addThingType(this.bundle, type.toThingType(this.channelTypes));
        }
        this.thingTypes.clear();
        this.channelTypes.clear();
    }

    public synchronized void release() {
        this.thingTypeProvider.removeAllThingTypes(this.bundle);
        this.configDescriptionProvider.removeAllConfigDescriptions(this.bundle);
    }
}

