/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.thing.binding.ThingTypeChangeListener;
import org.eclipse.smarthome.core.thing.binding.ThingTypeProvider;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlThingTypeProvider
implements ThingTypeProvider {
    private Logger logger = LoggerFactory.getLogger(XmlThingTypeProvider.class);
    private Map<Bundle, List<ThingType>> bundleThingTypesMap = new HashMap<Bundle, List<ThingType>>(10);
    private List<ThingTypeChangeListener> thingTypeChangeListeners = new CopyOnWriteArrayList<ThingTypeChangeListener>();

    private List<ThingType> acquireThingTypes(Bundle bundle) {
        if (bundle != null) {
            List<ThingType> thingTypes = this.bundleThingTypesMap.get(bundle);
            if (thingTypes == null) {
                thingTypes = new ArrayList<ThingType>(10);
                this.bundleThingTypesMap.put(bundle, thingTypes);
            }
            return thingTypes;
        }
        return null;
    }

    public synchronized void addThingType(Bundle bundle, ThingType thingType) {
        List<ThingType> thingTypes;
        if (thingType != null && (thingTypes = this.acquireThingTypes(bundle)) != null) {
            this.sendThingTypeEvent(thingType, true);
            thingTypes.add(thingType);
        }
    }

    public synchronized void removeAllThingTypes(Bundle bundle) {
        List<ThingType> thingTypes;
        if (bundle != null && (thingTypes = this.bundleThingTypesMap.get(bundle)) != null) {
            for (ThingType thingType : thingTypes) {
                this.sendThingTypeEvent(thingType, false);
            }
            this.bundleThingTypesMap.remove(bundle);
        }
    }

    public synchronized void addThingTypeChangeListener(ThingTypeChangeListener listener) {
        if (listener != null && !this.thingTypeChangeListeners.contains(listener)) {
            this.thingTypeChangeListeners.add(listener);
        }
    }

    public synchronized void removeThingTypeChangeListener(ThingTypeChangeListener listener) {
        if (listener != null) {
            this.thingTypeChangeListeners.remove(listener);
        }
    }

    public synchronized Collection<ThingType> getThingTypes() {
        ArrayList<ThingType> allThingTypes = new ArrayList<ThingType>();
        Collection<List<ThingType>> thingTypes = this.bundleThingTypesMap.values();
        if (thingTypes != null) {
            for (List<ThingType> thingType : thingTypes) {
                allThingTypes.addAll(thingType);
            }
        }
        return allThingTypes;
    }

    private void sendThingTypeEvent(ThingType thingType, boolean added) {
        for (ThingTypeChangeListener listener : this.thingTypeChangeListeners) {
            try {
                if (added) {
                    listener.thingTypeAdded((ThingTypeProvider)this, thingType);
                    continue;
                }
                listener.thingTypeRemoved((ThingTypeProvider)this, thingType);
            }
            catch (Exception ex) {
                this.logger.error("Could not send an " + (added ? "added" : "removed") + " ThingType event to the listener '" + listener + "'!", (Throwable)ex);
            }
        }
    }
}

