/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.types.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BaseThingHandler
implements ThingHandler {
    protected final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);
    private Thing thing;
    protected ThingRegistry thingRegistry;
    protected BundleContext bundleContext;
    private ServiceTracker thingRegistryServiceTracker;

    public BaseThingHandler(Thing thing) {
        this.thing = thing;
    }

    public void setBundleContext(final BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.thingRegistryServiceTracker = new ServiceTracker(this.bundleContext, ThingRegistry.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                BaseThingHandler.this.thingRegistry = (ThingRegistry)bundleContext.getService(reference);
                return BaseThingHandler.this.thingRegistry;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference reference, Object service) {
                BaseThingHandler baseThingHandler = BaseThingHandler.this;
                synchronized (baseThingHandler) {
                    BaseThingHandler.this.thingRegistry = null;
                }
            }
        };
        this.thingRegistryServiceTracker.open();
    }

    public void unsetBundleContext(BundleContext bundleContext) {
        this.thingRegistryServiceTracker.close();
        this.bundleContext = null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Thing getThing() {
        return this.thing;
    }

    @Override
    public void handleUpdate(ChannelUID channelUID, State newState) {
    }

    @Override
    public void initialize() {
        this.thing.setStatus(ThingStatus.ONLINE);
    }

    @Override
    public void thingUpdated(Thing thing) {
        this.dispose();
        this.thing = thing;
        this.initialize();
    }

    protected Configuration getConfig() {
        return this.getThing().getConfiguration();
    }

    protected <T> T getConfigAs(Class<T> configurationClass) {
        return (T)this.getConfig().as(configurationClass);
    }

    protected void updateState(ChannelUID channelUID, State state) {
        this.thing.channelUpdated(channelUID, state);
    }

    protected void updateState(String channelID, State state) {
        ChannelUID channelUID = new ChannelUID(this.getThing().getUID(), channelID);
        this.updateState(channelUID, state);
    }

    protected void updateStatus(ThingStatus status) {
        if (this.thing.getStatus() != status) {
            this.thing.setStatus(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bridge getBridge() {
        ThingUID bridgeUID = this.thing.getBridgeUID();
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (bridgeUID != null && this.thingRegistry != null) {
                return (Bridge)this.thingRegistry.getByUID(bridgeUID);
            }
            return null;
        }
    }
}

