/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BaseThingHandlerFactory
implements ThingHandlerFactory {
    protected BundleContext bundleContext;
    private Map<String, ServiceRegistration<ThingHandler>> thingHandlers = new HashMap<String, ServiceRegistration<ThingHandler>>();
    private ServiceTracker<ThingTypeRegistry, ThingTypeRegistry> thingTypeRegistryServiceTracker;

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.thingTypeRegistryServiceTracker = new ServiceTracker(this.bundleContext, ThingTypeRegistry.class.getName(), null);
        this.thingTypeRegistryServiceTracker.open();
    }

    protected void deactivate(ComponentContext componentContext) {
        for (ServiceRegistration<ThingHandler> serviceRegistration : this.thingHandlers.values()) {
            ThingHandler thingHandler = (ThingHandler)this.bundleContext.getService(serviceRegistration.getReference());
            if (thingHandler instanceof BaseThingHandler) {
                ((BaseThingHandler)thingHandler).unsetBundleContext(this.bundleContext);
            }
            thingHandler.dispose();
        }
        this.thingTypeRegistryServiceTracker.close();
        this.bundleContext = null;
    }

    @Override
    public void unregisterHandler(Thing thing) {
        ServiceRegistration<ThingHandler> serviceRegistration = this.thingHandlers.remove(thing.getUID().toString());
        if (serviceRegistration != null) {
            ThingHandler thingHandler = (ThingHandler)this.bundleContext.getService(serviceRegistration.getReference());
            serviceRegistration.unregister();
            this.removeHandler(thingHandler);
            thingHandler.dispose();
            if (thingHandler instanceof BaseThingHandler) {
                ((BaseThingHandler)thingHandler).unsetBundleContext(this.bundleContext);
            }
        }
    }

    @Override
    public void registerHandler(Thing thing) {
        ThingHandler thingHandler = this.createHandler(thing);
        if (thingHandler instanceof BaseThingHandler) {
            if (this.bundleContext == null) {
                throw new IllegalStateException("Base thing handler factory has not been properly initialized. Did you forget to call super.activate()?");
            }
            ((BaseThingHandler)thingHandler).setBundleContext(this.bundleContext);
        }
        thingHandler.initialize();
        ServiceRegistration<ThingHandler> serviceRegistration = this.registerAsService(thing, thingHandler);
        this.thingHandlers.put(thing.getUID().toString(), serviceRegistration);
    }

    private ServiceRegistration<ThingHandler> registerAsService(Thing thing, ThingHandler thingHandler) {
        Dictionary<String, Object> serviceProperties = this.getServiceProperties(thing, thingHandler);
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(ThingHandler.class.getName(), (Object)thingHandler, serviceProperties);
        return serviceRegistration;
    }

    private Dictionary<String, Object> getServiceProperties(Thing thing, ThingHandler thingHandler) {
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
        ((Dictionary)serviceProperties).put("thing.id", thing.getUID());
        ((Dictionary)serviceProperties).put("thing.type", thing.getThingTypeUID().toString());
        Map<String, Object> additionalServiceProperties = this.getServiceProperties(thingHandler);
        if (additionalServiceProperties != null) {
            for (Map.Entry<String, Object> additionalServiceProperty : additionalServiceProperties.entrySet()) {
                ((Dictionary)serviceProperties).put(additionalServiceProperty.getKey(), additionalServiceProperty.getValue());
            }
        }
        return serviceProperties;
    }

    protected Map<String, Object> getServiceProperties(ThingHandler thingHandler) {
        return null;
    }

    protected abstract ThingHandler createHandler(Thing var1);

    protected void removeHandler(ThingHandler thingHandler) {
    }

    @Override
    public void removeThing(ThingUID thingUID) {
    }

    protected ThingType getThingTypeByUID(ThingTypeUID thingTypeUID) {
        if (this.thingTypeRegistryServiceTracker == null) {
            throw new IllegalStateException("Base thing handler factory has not been properly initialized. Did you forget to call super.activate()?");
        }
        ThingTypeRegistry thingTypeRegistry = (ThingTypeRegistry)this.thingTypeRegistryServiceTracker.getService();
        if (thingTypeRegistry != null) {
            return thingTypeRegistry.getThingType(thingTypeUID);
        }
        return null;
    }

    protected Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID) {
        return this.createThing(thingTypeUID, configuration, thingUID, null);
    }

    @Override
    public Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID) {
        ThingType thingType = this.getThingTypeByUID(thingTypeUID);
        if (thingType != null) {
            return ThingFactory.createThing(thingType, thingUID, configuration, bridgeUID);
        }
        return null;
    }
}

