/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.builder.BridgeBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.GenericThingBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.type.BridgeType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ThingType;

public class ThingFactory {
    public static Thing createThing(ThingType thingType, ThingUID thingUID, Configuration configuration, ThingUID bridgeUID) {
        if (thingType == null) {
            throw new IllegalArgumentException("The thingType should not be null.");
        }
        if (thingUID == null) {
            throw new IllegalArgumentException("The thingUID should not be null.");
        }
        List<Channel> channels = ThingFactory.createChannels(thingType, thingUID);
        return ((GenericThingBuilder)((GenericThingBuilder)((GenericThingBuilder)ThingFactory.createThingBuilder(thingType, thingUID).withConfiguration(configuration)).withChannels(channels)).withBridge(bridgeUID)).build();
    }

    public static Thing createThing(ThingType thingType, ThingUID thingUID, Configuration configuration) {
        return ThingFactory.createThing(thingType, thingUID, configuration, null);
    }

    private static GenericThingBuilder<?> createThingBuilder(ThingType thingType, ThingUID thingUID) {
        if (thingType instanceof BridgeType) {
            return BridgeBuilder.create(thingUID);
        }
        return ThingBuilder.create(thingUID);
    }

    private static List<Channel> createChannels(ThingType thingType, ThingUID thingUID) {
        ArrayList channels = Lists.newArrayList();
        List<ChannelDefinition> channelDefinitions = thingType.getChannelDefinitions();
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            channels.add(ThingFactory.createChannel(channelDefinition, thingUID));
        }
        return channels;
    }

    private static Channel createChannel(ChannelDefinition channelDefinition, ThingUID thingUID) {
        ChannelType type = channelDefinition.getType();
        Channel channel = ChannelBuilder.create(new ChannelUID(thingUID, channelDefinition.getId()), type.getItemType()).build();
        return channel;
    }
}

