/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.core.events.AbstractEventSubscriber;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.internal.ThingImpl;
import org.eclipse.smarthome.core.thing.internal.ThingListener;
import org.eclipse.smarthome.core.thing.internal.ThingRegistryImpl;
import org.eclipse.smarthome.core.thing.internal.ThingTracker;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingManager
extends AbstractEventSubscriber
implements ThingTracker {
    private Logger logger = LoggerFactory.getLogger(ThingManager.class);
    private BundleContext bundleContext;
    private EventPublisher eventPublisher;
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();
    private Map<ThingUID, ThingHandler> thingHandlers = new ConcurrentHashMap<ThingUID, ThingHandler>();
    private ThingHandlerTracker thingHandlerTracker;
    private ThingListener thingListener = new ThingListener(){

        @Override
        public void channelUpdated(ChannelUID channelUID, State state) {
            String item = ThingManager.this.itemChannelLinkRegistry.getBoundItem(channelUID);
            if (item != null) {
                ThingManager.this.eventPublisher.postUpdate(item, state, channelUID.toString());
            }
        }
    };
    private ThingRegistryImpl thingRegistry;
    private Set<Thing> things = new CopyOnWriteArraySet<Thing>();

    public void handlerAdded(Thing thing, ThingHandler thingHandler) {
        this.logger.debug("Assigning handler for thing '{}'.", (Object)thing.getUID());
        ((ThingImpl)thing).addThingListener(this.thingListener);
        thing.setHandler(thingHandler);
    }

    public void handlerRemoved(Thing thing, ThingHandler thingHandler) {
        this.logger.debug("Removing handler and setting status to OFFLINE.", (Object)thing.getUID());
        ((ThingImpl)thing).removeThingListener(this.thingListener);
        thing.setHandler(null);
        thing.setStatus(ThingStatus.OFFLINE);
    }

    public void receiveCommand(String itemName, Command command) {
        for (Thing thing : this.things) {
            List<Channel> channels = thing.getChannels();
            for (Channel channel : channels) {
                if (!this.isLinked(itemName, channel)) continue;
                ThingHandler handler = thing.getHandler();
                if (handler != null) {
                    this.logger.debug("Delegating command '{}' for item '{}' to handler for channel '{}'", new Object[]{command, itemName, channel.getUID()});
                    try {
                        handler.handleCommand(channel.getUID(), command);
                    }
                    catch (Exception ex) {
                        this.logger.error("Exception occured while calling handler: " + ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                this.logger.warn("Cannot delegate command '{}' for item '{}' to handler for channel '{}', because no handler is assigned. Maybe the binding is not installed or not propertly initialized.", new Object[]{command, itemName, channel.getUID()});
            }
        }
    }

    public void receiveUpdate(String itemName, State newState, String source) {
        for (Thing thing : this.things) {
            List<Channel> channels = thing.getChannels();
            for (Channel channel : channels) {
                if (!this.isLinked(itemName, channel) || channel.getUID().toString().equals(source)) continue;
                ThingHandler handler = thing.getHandler();
                if (handler != null) {
                    this.logger.debug("Delegating update '{}' for item '{}' to handler for channel '{}'", new Object[]{newState, itemName, channel.getUID()});
                    try {
                        handler.handleUpdate(channel.getUID(), newState);
                    }
                    catch (Exception ex) {
                        this.logger.error("Exception occured while calling handler: " + ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                this.logger.warn("Cannot delegate update '{}' for item '{}' to handler for channel '{}', because no handler is assigned. Maybe the binding is not installed or not propertly initialized.", new Object[]{newState, itemName, channel.getUID()});
            }
        }
    }

    @Override
    public void thingAdded(Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        this.things.add(thing);
        this.logger.debug("Thing '{}' is tracked by ThingManager.", (Object)thing.getUID());
        ThingHandler thingHandler = this.thingHandlers.get(thing.getUID());
        if (thingHandler == null) {
            ThingHandlerFactory thingHandlerFactory = this.findThingHandlerFactory(thing);
            if (thingHandlerFactory != null) {
                this.registerHandler(thing, thingHandlerFactory);
            } else {
                this.logger.info("Cannot register handler. No handler factory for thing '{}' found.", (Object)thing.getUID());
            }
        } else {
            this.logger.debug("Handler for thing '{}' already exists.", (Object)thing.getUID());
            this.handlerAdded(thing, thingHandler);
        }
    }

    @Override
    public void thingRemoved(Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        ThingUID thingId;
        ThingHandler thingHandler;
        if (thingTrackerEvent == ThingTracker.ThingTrackerEvent.THING_REMOVED && (thingHandler = this.thingHandlers.get(thingId = thing.getUID())) != null) {
            ThingHandlerFactory thingHandlerFactory = this.findThingHandlerFactory(thing);
            if (thingHandlerFactory != null) {
                this.unregisterHandler(thing, thingHandlerFactory);
            } else {
                this.logger.warn("Cannot unregister handler. No handler factory for thing '{}' found.", (Object)thing.getUID());
            }
        }
        this.logger.debug("Thing '{}' is no longer tracked by ThingManager.", (Object)thing.getUID());
        this.things.remove(thing);
    }

    @Override
    public void thingUpdated(Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        ThingUID thingId;
        ThingHandler thingHandler;
        if (thingTrackerEvent == ThingTracker.ThingTrackerEvent.THING_UPDATED && (thingHandler = this.thingHandlers.get(thingId = thing.getUID())) != null) {
            try {
                thingHandler.thingUpdated(thing);
            }
            catch (Exception ex) {
                this.logger.error("Cannot send Thing updated event to ThingHandler '" + thingHandler + "'!", (Throwable)ex);
            }
        }
    }

    private ThingHandlerFactory findThingHandlerFactory(Thing thing) {
        for (ThingHandlerFactory factory : this.thingHandlerFactories) {
            if (!factory.supportsThingType(thing.getThingTypeUID())) continue;
            return factory;
        }
        return null;
    }

    private Thing getThing(ThingUID id) {
        for (Thing thing : this.things) {
            if (!thing.getUID().equals(id)) continue;
            return thing;
        }
        return null;
    }

    private boolean isLinked(String itemName, Channel channel) {
        return this.itemChannelLinkRegistry.isLinked(itemName, channel.getUID());
    }

    private void registerHandler(Thing thing, ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Creating handler for thing '{}'.", (Object)thing.getUID());
        try {
            thingHandlerFactory.registerHandler(thing);
        }
        catch (Exception ex) {
            this.logger.error("Exception occured while calling handler: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void unregisterHandler(Thing thing, ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Removing handler for thing '{}'.", (Object)thing.getUID());
        try {
            thingHandlerFactory.unregisterHandler(thing);
        }
        catch (Exception ex) {
            this.logger.error("Exception occured while calling handler: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.thingHandlerTracker = new ThingHandlerTracker(this.bundleContext);
        this.thingHandlerTracker.open();
    }

    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Thing handler factory '{}' added", (Object)thingHandlerFactory.getClass().getSimpleName());
        this.thingHandlerFactories.add(thingHandlerFactory);
        for (Thing thing : this.things) {
            if (!thingHandlerFactory.supportsThingType(thing.getThingTypeUID())) continue;
            ThingUID thingId = thing.getUID();
            ThingHandler thingHandler = this.thingHandlers.get(thingId);
            if (thingHandler == null) {
                this.registerHandler(thing, thingHandlerFactory);
                continue;
            }
            this.logger.warn("Thing handler for thing '{}' already exists.", (Object)thingId);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.thingHandlerTracker.close();
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Thing handler factory '{}' removed", (Object)thingHandlerFactory.getClass().getSimpleName());
        this.thingHandlerFactories.remove(thingHandlerFactory);
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = (ThingRegistryImpl)thingRegistry;
        this.thingRegistry.addThingTracker(this);
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry.removeThingTracker(this);
        this.thingRegistry = null;
    }

    private final class ThingHandlerTracker
    extends ServiceTracker<ThingHandler, ThingHandler> {
        public ThingHandlerTracker(BundleContext context) {
            super(context, ThingHandler.class.getName(), null);
        }

        public ThingHandler addingService(ServiceReference<ThingHandler> reference) {
            ThingUID thingId = this.getThingId(reference);
            ThingManager.this.logger.debug("Thing handler for thing '{}' added.", (Object)thingId);
            ThingHandler thingHandler = (ThingHandler)ThingManager.this.bundleContext.getService(reference);
            Thing thing = ThingManager.this.getThing(thingId);
            if (thing != null) {
                ThingManager.this.handlerAdded(thing, thingHandler);
            } else {
                ThingManager.this.logger.warn("Found handler for non-existing thing '{}'.", (Object)thingId);
            }
            ThingManager.this.thingHandlers.put(thingId, thingHandler);
            return thingHandler;
        }

        public void removedService(ServiceReference<ThingHandler> reference, ThingHandler service) {
            ThingUID thingId = this.getThingId(reference);
            ThingManager.this.logger.debug("Thing handler for thing '{}' removed.", (Object)thingId);
            Thing thing = ThingManager.this.getThing(thingId);
            if (thing != null) {
                ThingManager.this.handlerRemoved(thing, service);
            }
            ThingManager.this.thingHandlers.remove(this.getThingId(reference));
        }

        private ThingUID getThingId(ServiceReference<ThingHandler> reference) {
            return (ThingUID)reference.getProperty("thing.id");
        }
    }
}

