/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link;

import org.eclipse.smarthome.core.thing.ChannelUID;

public class ItemChannelLink {
    private final String itemName;
    private final ChannelUID channelUID;

    public ItemChannelLink(String itemName, ChannelUID channelUID) {
        this.itemName = itemName;
        this.channelUID = channelUID;
    }

    public String getItemName() {
        return this.itemName;
    }

    public ChannelUID getChannelUID() {
        return this.channelUID;
    }

    public String getID() {
        return String.valueOf(this.itemName) + " -> " + this.getChannelUID().toString();
    }

    public String toString() {
        return this.getID();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemChannelLink)) {
            return false;
        }
        ItemChannelLink other = (ItemChannelLink)obj;
        if (!this.itemName.equals(other.itemName)) {
            return false;
        }
        return this.channelUID.equals(other.channelUID);
    }

    public int hashCode() {
        return this.itemName.hashCode() * this.channelUID.hashCode();
    }
}

