/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.transform;

import java.util.Collection;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationHelper {
    private static Logger logger = LoggerFactory.getLogger(TransformationHelper.class);

    public static TransformationService getTransformationService(BundleContext context, String transformationType) {
        if (context != null) {
            String filter = "(smarthome.transform=" + transformationType + ")";
            try {
                Collection refs = context.getServiceReferences(TransformationService.class, filter);
                if (refs != null && refs.size() > 0) {
                    return (TransformationService)context.getService((ServiceReference)refs.iterator().next());
                }
                logger.warn("Cannot get service reference for transformation service of type " + transformationType);
            }
            catch (InvalidSyntaxException e) {
                logger.warn("Cannot get service reference for transformation service of type " + transformationType, (Throwable)e);
            }
        }
        return null;
    }
}

