/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.transform.internal.service;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.config.core.ConfigDispatcher;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTransformationService
implements TransformationService {
    static final Logger logger = LoggerFactory.getLogger(MapTransformationService.class);

    @Override
    public String transform(String filename, String source) throws TransformationException {
        FileReader reader;
        block6: {
            if (filename == null || source == null) {
                throw new TransformationException("the given parameters 'filename' and 'source' must not be null");
            }
            reader = null;
            String path = String.valueOf(ConfigDispatcher.getConfigFolder()) + File.separator + "transform" + File.separator + filename;
            Properties properties = new Properties();
            reader = new FileReader(path);
            properties.load(reader);
            String target = properties.getProperty(source);
            if (target == null) break block6;
            logger.debug("transformation resulted in '{}'", (Object)target);
            String string = target;
            IOUtils.closeQuietly((Reader)reader);
            return string;
        }
        try {
            logger.warn("Could not find a mapping for '{}' in the file '{}'.", (Object)source, (Object)filename);
        }
        catch (IOException e) {
            try {
                String message = "opening file '" + filename + "' throws exception";
                logger.error(message, (Throwable)e);
                throw new TransformationException(message, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return "";
    }
}

