/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.transform.internal.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExTransformationService
implements TransformationService {
    static final Logger logger = LoggerFactory.getLogger(RegExTransformationService.class);

    @Override
    public String transform(String regExpression, String source) throws TransformationException {
        if (regExpression == null || source == null) {
            throw new TransformationException("the given parameters 'regex' and 'source' must not be null");
        }
        logger.debug("about to transform '{}' by the function '{}'", (Object)source, (Object)regExpression);
        Matcher matcher = Pattern.compile("^" + regExpression + "$", 32).matcher(source.trim());
        if (!matcher.matches()) {
            logger.debug("the given regex '^{}$' doesn't match the given content '{}' -> couldn't compute transformation", (Object)regExpression, (Object)source);
            return null;
        }
        matcher.reset();
        String result = "";
        while (matcher.find()) {
            if (matcher.groupCount() == 0) {
                logger.info("the given regular expression '^{}$' doesn't contain a group. No content will be extracted and returned!", (Object)regExpression);
                continue;
            }
            result = matcher.group(1);
            if (matcher.groupCount() <= 1) continue;
            logger.debug("the given regular expression '^{}$' contains more than one group. Only the first group will be returned!", (Object)regExpression);
        }
        return result;
    }
}

