/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.common.registry.AbstractManagedProvider;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedItemProvider
extends AbstractManagedProvider<Item, String, PersistedItem>
implements ItemProvider {
    private static final String ITEM_TYPE_GROUP = "Group";
    private static final Logger logger = LoggerFactory.getLogger(ManagedItemProvider.class);
    private Collection<ItemFactory> itemFactories = new CopyOnWriteArrayList<ItemFactory>();

    private GenericItem createItem(String itemType, String itemName) {
        for (ItemFactory factory : this.itemFactories) {
            GenericItem item = factory.createItem(itemType, itemName);
            if (item == null) continue;
            return item;
        }
        logger.debug("Couldn't find ItemFactory for item '{}' of type '{}'", (Object)itemName, (Object)itemType);
        return null;
    }

    private String toItemFactoryName(Item item) {
        return item.getType();
    }

    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
    }

    @Override
    protected String getKey(Item element) {
        return element.getName();
    }

    @Override
    protected String getStorageName() {
        return Item.class.getName();
    }

    @Override
    protected String keyToString(String key) {
        return key;
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }

    @Override
    protected Item toElement(String itemName, PersistedItem persistedItem) {
        GenericItem item = null;
        if (persistedItem.itemType.equals(ITEM_TYPE_GROUP)) {
            if (persistedItem.baseItemType != null) {
                GenericItem baseItem = this.createItem(persistedItem.baseItemType, itemName);
                item = new GroupItem(itemName, baseItem);
            } else {
                item = new GroupItem(itemName);
            }
        } else {
            item = this.createItem(persistedItem.itemType, itemName);
        }
        List<String> groupNames = persistedItem.groupNames;
        if (item != null && groupNames != null) {
            for (String groupName : groupNames) {
                item.addGroupName(groupName);
            }
        }
        if (item == null) {
            logger.debug("Couldn't restore item '{}' of type '{}' ~\u00a0there is no appropriate ItemFactory available.", (Object)itemName, (Object)persistedItem.itemType);
        }
        return item;
    }

    @Override
    protected PersistedItem toPersistableElement(Item item) {
        PersistedItem persistedItem;
        String itemType = this.toItemFactoryName(item);
        if (item instanceof GroupItem) {
            String baseItemType = null;
            GenericItem baseItem = ((GroupItem)item).getBaseItem();
            if (baseItem != null) {
                baseItemType = this.toItemFactoryName(baseItem);
            }
            persistedItem = new PersistedItem(ITEM_TYPE_GROUP, item.getGroupNames(), baseItemType);
        } else {
            persistedItem = new PersistedItem(itemType, item.getGroupNames());
        }
        return persistedItem;
    }

    public static class PersistedItem {
        public String baseItemType;
        public List<String> groupNames;
        public String itemType;

        public PersistedItem(String itemType, List<String> groupNames) {
            this(itemType, groupNames, null);
        }

        public PersistedItem(String itemType, List<String> groupNames, String baseItemType) {
            this.itemType = itemType;
            this.groupNames = groupNames;
            this.baseItemType = baseItemType;
        }
    }
}

