package org.eclipse.smarthome.designer.core.config;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.smarthome.core.scriptengine.action.ActionService;
import org.eclipse.smarthome.designer.core.CoreActivator;
import org.eclipse.smarthome.designer.core.config.IProjectCreator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class PluginProjectCreator implements IProjectCreator {
  public IProject createProject(final String projectName) {
    try {
      IProject _xblockexpression = null;
      {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = workspace.getRoot();
        final IProject project = _root.getProject(projectName);
        final IJavaProject javaProject = JavaCore.create(project);
        IProjectDescription _xifexpression = null;
        boolean _exists = project.exists();
        if (_exists) {
          _xifexpression = project.getDescription();
        } else {
          IProjectDescription _newProjectDescription = workspace.newProjectDescription(projectName);
          final Procedure1<IProjectDescription> _function = new Procedure1<IProjectDescription>() {
            public void apply(final IProjectDescription it) {
              try {
                it.setLocation(null);
                project.create(it, null);
              } catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
              }
            }
          };
          _xifexpression = ObjectExtensions.<IProjectDescription>operator_doubleArrow(_newProjectDescription, _function);
        }
        final IProjectDescription projectDescription = _xifexpression;
        projectDescription.setNatureIds(new String[] { JavaCore.NATURE_ID, "org.eclipse.pde.PluginNature", "org.eclipse.xtext.ui.shared.xtextNature" });
        final ArrayList<ICommand> builders = CollectionLiterals.<ICommand>newArrayList();
        ICommand _newCommand = projectDescription.newCommand();
        final Procedure1<ICommand> _function_1 = new Procedure1<ICommand>() {
          public void apply(final ICommand it) {
            it.setBuilderName(JavaCore.BUILDER_ID);
          }
        };
        ICommand _doubleArrow = ObjectExtensions.<ICommand>operator_doubleArrow(_newCommand, _function_1);
        builders.add(_doubleArrow);
        ICommand _newCommand_1 = projectDescription.newCommand();
        final Procedure1<ICommand> _function_2 = new Procedure1<ICommand>() {
          public void apply(final ICommand it) {
            it.setBuilderName("org.eclipse.pde.ManifestBuilder");
          }
        };
        ICommand _doubleArrow_1 = ObjectExtensions.<ICommand>operator_doubleArrow(_newCommand_1, _function_2);
        builders.add(_doubleArrow_1);
        ICommand _newCommand_2 = projectDescription.newCommand();
        final Procedure1<ICommand> _function_3 = new Procedure1<ICommand>() {
          public void apply(final ICommand it) {
            it.setBuilderName("org.eclipse.pde.SchemaBuilder");
          }
        };
        ICommand _doubleArrow_2 = ObjectExtensions.<ICommand>operator_doubleArrow(_newCommand_2, _function_3);
        builders.add(_doubleArrow_2);
        ICommand _newCommand_3 = projectDescription.newCommand();
        final Procedure1<ICommand> _function_4 = new Procedure1<ICommand>() {
          public void apply(final ICommand it) {
            it.setBuilderName("org.eclipse.xtext.ui.shared.xtextBuilder");
          }
        };
        ICommand _doubleArrow_3 = ObjectExtensions.<ICommand>operator_doubleArrow(_newCommand_3, _function_4);
        builders.add(_doubleArrow_3);
        projectDescription.setBuildSpec(((ICommand[])Conversions.unwrapArray(builders, ICommand.class)));
        project.open(null);
        project.setDescription(projectDescription, null);
        final ArrayList<IClasspathEntry> classpathEntries = CollectionLiterals.<IClasspathEntry>newArrayList();
        Path _path = new Path("org.eclipse.jdt.launching.JRE_CONTAINER");
        IClasspathEntry _newContainerEntry = JavaCore.newContainerEntry(_path);
        classpathEntries.add(_newContainerEntry);
        Path _path_1 = new Path("org.eclipse.pde.core.requiredPlugins");
        IClasspathEntry _newContainerEntry_1 = JavaCore.newContainerEntry(_path_1);
        classpathEntries.add(_newContainerEntry_1);
        javaProject.setRawClasspath(((IClasspathEntry[])Conversions.unwrapArray(classpathEntries, IClasspathEntry.class)), null);
        Path _path_2 = new Path((("/" + projectName) + "/bin"));
        javaProject.setOutputLocation(_path_2, null);
        this.createManifest(project);
        this.createBuildProps(project);
        this.setJavaVM();
        _xblockexpression = project;
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private void setJavaVM() {
    try {
      final String javaHome = System.getProperty("java.home");
      boolean _equals = Objects.equal(javaHome, null);
      if (_equals) {
        throw new RuntimeException("JAVA_HOME environment variable has to be specified!");
      }
      final IEclipsePreferences jdtLaunchingPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
      _builder.newLine();
      _builder.append("<vmSettings defaultVM=\"57,org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType13,1393576529277\">");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("<vmType id=\"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType\">");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("<vm id=\"1393576529277\" javadocURL=\"http://download.oracle.com/javase/7/docs/api/\" name=\"JAVA_HOME_JRE\" path=\"");
      _builder.append(javaHome, "\t\t");
      _builder.append("\">");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("</vm>");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("</vmType>");
      _builder.newLine();
      _builder.append("</vmSettings>");
      _builder.newLine();
      final String xmlValue = _builder.toString();
      jdtLaunchingPreferences.put("org.eclipse.jdt.launching.PREF_VM_XML", xmlValue);
      jdtLaunchingPreferences.flush();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private void createManifest(final IProject project) throws CoreException {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Manifest-Version: 1.0");
    _builder.newLine();
    _builder.append("Bundle-ManifestVersion: 2");
    _builder.newLine();
    _builder.append("Bundle-Name: Eclipse SmartHome Designer Project");
    _builder.newLine();
    _builder.append("Bundle-SymbolicName: ");
    String _name = project.getName();
    _builder.append(_name, "");
    _builder.append(";singleton:=true");
    _builder.newLineIfNotEmpty();
    _builder.append("Bundle-Version: 1.0.0.qualifier");
    _builder.newLine();
    _builder.append("Bundle-Vendor: Eclipse.org/SmartHome");
    _builder.newLine();
    _builder.append("Require-Bundle: org.eclipse.xtext.xbase.lib");
    _builder.newLine();
    _builder.append("Import-Package: org.eclipse.smarthome.model.script.actions,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.joda.time,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.osgi.service.cm,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.smarthome.core.library.types,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.smarthome.core.library.items,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.smarthome.core.items,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.smarthome.core.persistence");
    {
      Set<String> _importedPackages = this.getImportedPackages();
      boolean _isEmpty = _importedPackages.isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append(",");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      Set<String> _importedPackages_1 = this.getImportedPackages();
      boolean _hasElements = false;
      for(final String importPackage : _importedPackages_1) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "");
        }
        _builder.append((" " + importPackage), "");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.7");
    _builder.newLine();
    _builder.append("Bundle-ActivationPolicy: lazy");
    _builder.newLine();
    final String manifestContent = _builder.toString();
    final IFolder metaInfFolder = project.getFolder("META-INF");
    boolean _exists = metaInfFolder.exists();
    boolean _not_1 = (!_exists);
    if (_not_1) {
      metaInfFolder.create(false, true, null);
    }
    this.createFile("MANIFEST.MF", metaInfFolder, manifestContent);
  }
  
  private Set<String> getImportedPackages() {
    Set<String> _xblockexpression = null;
    {
      Object[] _services = CoreActivator.actionServiceTracker.getServices();
      final Iterable<ActionService> actionServices = Iterables.<ActionService>filter(((Iterable<?>)Conversions.doWrapArray(_services)), ActionService.class);
      final Function1<ActionService, String> _function = new Function1<ActionService, String>() {
        public String apply(final ActionService it) {
          Class<?> _actionClass = it.getActionClass();
          Package _package = _actionClass.getPackage();
          return _package.getName();
        }
      };
      Iterable<String> _map = IterableExtensions.<ActionService, String>map(actionServices, _function);
      _xblockexpression = IterableExtensions.<String>toSet(_map);
    }
    return _xblockexpression;
  }
  
  private void createBuildProps(final IProject project) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("bin.includes = META-INF/,\\");
    _builder.newLine();
    _builder.append("               ");
    _builder.append(".");
    _builder.newLine();
    final String buildPropertiesContent = _builder.toString();
    this.createFile("build.properties", project, buildPropertiesContent);
  }
  
  public IFile createFile(final String name, final IContainer container, final String content) {
    try {
      Path _path = new Path(name);
      final IFile file = container.getFile(_path);
      String _charset = file.getCharset();
      byte[] _bytes = content.getBytes(_charset);
      final InputStream stream = new ByteArrayInputStream(_bytes);
      boolean _exists = file.exists();
      if (_exists) {
        file.setContents(stream, true, true, null);
      } else {
        file.create(stream, true, null);
      }
      stream.close();
      return file;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private void assertExist(final IContainer c) {
    try {
      boolean _exists = c.exists();
      boolean _not = (!_exists);
      if (_not) {
        IContainer _parent = c.getParent();
        boolean _exists_1 = _parent.exists();
        boolean _not_1 = (!_exists_1);
        if (_not_1) {
          IContainer _parent_1 = c.getParent();
          this.assertExist(_parent_1);
        }
        if ((c instanceof IFolder)) {
          ((IFolder)c).create(false, true, null);
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
