/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.designer.core.config;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.smarthome.config.core.ConfigDispatcher;
import org.eclipse.smarthome.designer.core.CoreActivator;
import org.eclipse.smarthome.designer.core.config.IProjectCreator;
import org.eclipse.smarthome.designer.core.config.PluginProjectCreator;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFolderProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationFolderProvider.class);
    private static IFolder folder;
    private static IProjectCreator projectCreator;

    static {
        projectCreator = new PluginProjectCreator();
    }

    public static synchronized IFolder getRootConfigurationFolder() throws CoreException {
        if (folder == null) {
            IProject project = projectCreator.createProject("config");
            File configFolder = ConfigurationFolderProvider.getFolderFromPreferences();
            if (configFolder != null) {
                folder = project.getFolder("config");
                folder.createLink(configFolder.toURI(), 384, null);
                ConfigDispatcher.setConfigFolder((String)configFolder.getAbsolutePath());
            }
        }
        return folder;
    }

    public static synchronized void setRootConfigurationFolder(final File configFolder) throws CoreException {
        ConfigDispatcher.setConfigFolder((String)configFolder.getAbsolutePath());
        try {
            CoreActivator.updateFolderObserver();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.smarthome.designer.core", e.getMessage()));
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = projectCreator.createProject("config");
                if (configFolder != null) {
                    folder = project.getFolder("config");
                    if (folder.exists()) {
                        folder.delete(true, null);
                    }
                    folder.createLink(configFolder.toURI(), 16, null);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    private static File getFolderFromPreferences() {
        String folderPath;
        IPreferencesService service = Platform.getPreferencesService();
        Preferences node = service.getRootNode().node("configuration").node("org.eclipse.smarthome.designer.core");
        if (node != null && (folderPath = node.get("CONFIG_FOLDER_PREFERENCE", null)) != null) {
            File file = new File(folderPath);
            if (file != null && file.isDirectory()) {
                return file;
            }
            logger.warn("'{}' is no valid directory.", (Object)folderPath);
        }
        return null;
    }

    public static void saveFolderToPreferences(String folderPath) {
        IPreferencesService service = Platform.getPreferencesService();
        Preferences node = service.getRootNode().node("configuration").node("org.eclipse.smarthome.designer.core");
        try {
            if (node != null) {
                node.put("CONFIG_FOLDER_PREFERENCE", folderPath);
                node.flush();
                return;
            }
        }
        catch (BackingStoreException backingStoreException) {}
        logger.warn("Could not save folder '{}' to preferences.", (Object)folderPath);
    }
}

