/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.eclipse.smarthome.io.console.internal.ConsoleActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleInterpreter {
    protected static final Logger logger = LoggerFactory.getLogger(ConsoleInterpreter.class);

    public static void handleRequest(String[] args, Console console, Set<ConsoleCommandExtension> consoleCommandExtensions) {
        String arg = args[0];
        boolean handledByExtension = false;
        Iterator<ConsoleCommandExtension> extensionIterator = consoleCommandExtensions.iterator();
        while (!handledByExtension && extensionIterator.hasNext()) {
            ConsoleCommandExtension consoleCommandExtension = extensionIterator.next();
            boolean canHandle = false;
            try {
                canHandle = consoleCommandExtension.canHandle(args);
            }
            catch (Exception e) {
                logger.error("An error occured while invoking the command extension's can handle method.", (Throwable)e);
            }
            if (!canHandle) continue;
            handledByExtension = true;
            try {
                consoleCommandExtension.execute(args, console);
            }
            catch (Exception e) {
                logger.error("An error occured while executing the console command.", (Throwable)e);
                console.println("An unexpected error occured during execution.");
            }
        }
        if (!handledByExtension) {
            args = (String[])ArrayUtils.remove((Object[])args, (int)0);
            if (arg.equals("items")) {
                ConsoleInterpreter.handleItems(args, console);
            } else if (arg.equals("send")) {
                ConsoleInterpreter.handleSend(args, console);
            } else if (arg.equals("update")) {
                ConsoleInterpreter.handleUpdate(args, console);
            } else if (arg.equals("status")) {
                ConsoleInterpreter.handleStatus(args, console);
            } else {
                console.printUsage(ConsoleInterpreter.getUsage(consoleCommandExtensions));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void handleUpdate(String[] args, Console console) {
        block14: {
            registry = (ItemRegistry)ConsoleActivator.itemRegistryTracker.getService();
            publisher = (EventPublisher)ConsoleActivator.eventPublisherTracker.getService();
            if (publisher != null) {
                if (registry != null) {
                    if (args.length > 0) {
                        itemName = args[0];
                        try {
                            item = registry.getItemByPattern(itemName);
                            if (args.length > 1) {
                                stateName = args[1];
                                state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)stateName);
                                if (state != null) {
                                    publisher.postUpdate(item.getName(), state);
                                    console.println("Update has been sent successfully.");
                                } else {
                                    console.println("Error: State '" + stateName + "' is not valid for item '" + itemName + "'");
                                    console.print("Valid data types are: ( ");
                                    for (Class acceptedType : item.getAcceptedDataTypes()) {
                                        console.print(String.valueOf(acceptedType.getSimpleName()) + " ");
                                    }
                                    console.println(")");
                                }
                            } else {
                                console.printUsage(ConsoleInterpreter.getUpdateUsage());
                            }
                            break block14;
                        }
                        catch (ItemNotFoundException v0) {
                            console.println("Error: Item '" + itemName + "' does not exist.");
                            break block14;
                        }
                        catch (ItemNotUniqueException e) {
                            console.print("Error: Multiple items match this pattern: ");
                            ** for (item : e.getMatchingItems())
                        }
lbl-1000:
                        // 1 sources

                        {
                            console.print(String.valueOf(item.getName()) + " ");
                            continue;
lbl33:
                            // 1 sources

                            break block14;
                        }
                    }
                    console.printUsage(ConsoleInterpreter.getUpdateUsage());
                } else {
                    console.println("Sorry, no item registry service available!");
                }
            } else {
                console.println("Sorry, no event publisher service available!");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void handleSend(String[] args, Console console) {
        block14: {
            registry = (ItemRegistry)ConsoleActivator.itemRegistryTracker.getService();
            publisher = (EventPublisher)ConsoleActivator.eventPublisherTracker.getService();
            if (publisher != null) {
                if (registry != null) {
                    if (args.length > 0) {
                        itemName = args[0];
                        try {
                            item = registry.getItemByPattern(itemName);
                            if (args.length > 1) {
                                commandName = args[1];
                                command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandName);
                                if (command != null) {
                                    publisher.sendCommand(itemName, command);
                                    console.println("Command has been sent successfully.");
                                } else {
                                    console.println("Error: Command '" + commandName + "' is not valid for item '" + itemName + "'");
                                    console.print("Valid command types are: ( ");
                                    for (Class acceptedType : item.getAcceptedCommandTypes()) {
                                        console.print(String.valueOf(acceptedType.getSimpleName()) + " ");
                                    }
                                    console.println(")");
                                }
                            } else {
                                console.printUsage(ConsoleInterpreter.getCommandUsage());
                            }
                            break block14;
                        }
                        catch (ItemNotFoundException v0) {
                            console.println("Error: Item '" + itemName + "' does not exist.");
                            break block14;
                        }
                        catch (ItemNotUniqueException e) {
                            console.print("Error: Multiple items match this pattern: ");
                            ** for (item : e.getMatchingItems())
                        }
lbl-1000:
                        // 1 sources

                        {
                            console.print(String.valueOf(item.getName()) + " ");
                            continue;
lbl33:
                            // 1 sources

                            break block14;
                        }
                    }
                    console.printUsage(ConsoleInterpreter.getCommandUsage());
                } else {
                    console.println("Sorry, no item registry service available!");
                }
            } else {
                console.println("Sorry, no event publisher service available!");
            }
        }
    }

    public static void handleItems(String[] args, Console console) {
        ItemRegistry registry = (ItemRegistry)ConsoleActivator.itemRegistryTracker.getService();
        if (registry != null) {
            String pattern = args.length == 0 ? "*" : args[0];
            Collection items = registry.getItems(pattern);
            if (items.size() > 0) {
                for (Item item : items) {
                    console.println(item.toString());
                }
            } else {
                console.println("No items found for this pattern.");
            }
        } else {
            console.println("Sorry, no item registry service available!");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void handleStatus(String[] args, Console console) {
        block7: {
            registry = (ItemRegistry)ConsoleActivator.itemRegistryTracker.getService();
            if (registry != null) {
                if (args.length > 0) {
                    itemName = args[0];
                    try {
                        item = registry.getItemByPattern(itemName);
                        console.println(item.getState().toString());
                        break block7;
                    }
                    catch (ItemNotFoundException v0) {
                        console.println("Error: Item '" + itemName + "' does not exist.");
                        break block7;
                    }
                    catch (ItemNotUniqueException e) {
                        console.print("Error: Multiple items match this pattern: ");
                        ** for (item : e.getMatchingItems())
                    }
lbl-1000:
                    // 1 sources

                    {
                        console.print(String.valueOf(item.getName()) + " ");
                        continue;
lbl17:
                        // 1 sources

                        break block7;
                    }
                }
                console.printUsage(ConsoleInterpreter.getStatusUsage());
            } else {
                console.println("Sorry, no item registry service available!");
            }
        }
    }

    private static String getUsage(Set<ConsoleCommandExtension> consoleCommandExtensions) {
        StringBuilder sb = new StringBuilder();
        for (String usage : ConsoleInterpreter.getUsages(consoleCommandExtensions)) {
            sb.append(String.valueOf(usage) + "\n");
        }
        return sb.toString();
    }

    public static List<String> getUsages(Set<ConsoleCommandExtension> consoleCommandExtensions) {
        ArrayList<String> usages = new ArrayList<String>();
        for (ConsoleCommandExtension consoleCommandExtension : consoleCommandExtensions) {
            usages.addAll(consoleCommandExtension.getUsages());
        }
        usages.add(ConsoleInterpreter.getUpdateUsage());
        usages.add(ConsoleInterpreter.getCommandUsage());
        usages.add(ConsoleInterpreter.getStatusUsage());
        usages.add(ConsoleInterpreter.getItemsUsage());
        return usages;
    }

    public static String getUpdateUsage() {
        return "update <item> <state> - sends a status update for an item";
    }

    public static String getCommandUsage() {
        return "send <item> <command> - sends a command for an item";
    }

    public static String getStatusUsage() {
        return "status <item> - shows the current status of an item";
    }

    public static String getItemsUsage() {
        return "items [<pattern>] - lists names and types of all items matching the pattern";
    }
}

