/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.mdns.internal;

import java.io.IOException;
import java.util.concurrent.Executors;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.eclipse.smarthome.io.mdns.MDNSService;
import org.eclipse.smarthome.io.mdns.ServiceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNSServiceImpl
implements MDNSService {
    private static Logger logger = LoggerFactory.getLogger(MDNSServiceImpl.class);
    private JmDNS jmdns;

    @Override
    public void registerService(final ServiceDescription description) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ServiceInfo serviceInfo = ServiceInfo.create((String)description.serviceType, (String)description.serviceName, (int)description.servicePort, (int)0, (int)0, description.serviceProperties);
                try {
                    logger.debug("Registering new service " + description.serviceType + " at port " + String.valueOf(description.servicePort));
                    MDNSServiceImpl.this.jmdns.registerService(serviceInfo);
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        };
        Executors.newSingleThreadExecutor().execute(runnable);
    }

    @Override
    public void unregisterService(ServiceDescription description) {
        ServiceInfo serviceInfo = ServiceInfo.create((String)description.serviceType, (String)description.serviceName, (int)description.servicePort, (int)0, (int)0, description.serviceProperties);
        logger.debug("Unregistering service " + description.serviceType + " at port " + String.valueOf(description.servicePort));
        this.jmdns.unregisterService(serviceInfo);
    }

    protected void unregisterAllServices() {
        this.jmdns.unregisterAllServices();
    }

    public void activate() {
        try {
            this.jmdns = JmDNS.create();
            logger.debug("mDNS service has been started");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    public void deactivate() {
        this.unregisterAllServices();
        try {
            this.jmdns.close();
            logger.debug("mDNS service has been stopped");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }
}

