/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.multimedia.internal.tts;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.smarthome.io.multimedia.tts.TTSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTSServiceMacOS
implements TTSService {
    private static final Logger logger = LoggerFactory.getLogger(TTSServiceMacOS.class);

    @Override
    public synchronized void say(String text, String voiceName, String outputDevice) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("say");
        if (outputDevice != null) {
            list.add("-a");
            list.add(outputDevice);
        }
        if (voiceName != null) {
            list.add("-v");
            list.add(voiceName);
        }
        list.add(text.replace("-", " minus "));
        try {
            Process process = Runtime.getRuntime().exec(list.toArray(new String[list.size()]));
            process.waitFor();
        }
        catch (IOException e) {
            logger.error("Error while executing the 'say' command: " + e.getMessage());
        }
        catch (InterruptedException e) {
            logger.error("The 'say' command has been interrupted: " + e.getMessage());
        }
    }
}

