/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.item;

import com.sun.jersey.api.json.JSONWithPadding;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.library.items.RollershutterItem;
import org.eclipse.smarthome.core.library.items.SwitchItem;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.io.rest.MediaTypeHelper;
import org.eclipse.smarthome.io.rest.RESTApplication;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.item.beans.GroupItemBean;
import org.eclipse.smarthome.io.rest.item.beans.ItemBean;
import org.eclipse.smarthome.io.rest.item.beans.ItemListBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
public class ItemResource
implements RESTResource {
    private static final Logger logger = LoggerFactory.getLogger(ItemResource.class);
    public static final String PATH_ITEMS = "items";
    @Context
    UriInfo uriInfo;
    @Context
    UriInfo localUriInfo;

    @GET
    @Produces(value={"*/*"})
    public Response getItems(@Context HttpHeaders headers, @QueryParam(value="type") String type, @QueryParam(value="jsoncallback") @DefaultValue(value="callback") String callback) {
        logger.debug("Received HTTP GET request at '{}' for media type '{}'.", new Object[]{this.uriInfo.getPath(), type});
        String responseType = MediaTypeHelper.getResponseMediaType((List)headers.getAcceptableMediaTypes(), (String)type);
        if (responseType != null) {
            Object responseObject = responseType.equals("application/x-javascript") ? new JSONWithPadding((Object)new ItemListBean(this.getItemBeans()), callback) : new ItemListBean(this.getItemBeans());
            return Response.ok((Object)responseObject, (String)responseType).build();
        }
        return Response.notAcceptable(null).build();
    }

    @GET
    @Path(value="/{itemname: [a-zA-Z_0-9]*}/state")
    @Produces(value={"text/plain"})
    public Response getPlainItemState(@PathParam(value="itemname") String itemname) {
        Item item = ItemResource.getItem(itemname);
        if (item != null) {
            logger.debug("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
            throw new WebApplicationException(Response.ok((Object)item.getState().toString()).build());
        }
        logger.info("Received HTTP GET request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
        throw new WebApplicationException(404);
    }

    @GET
    @Path(value="/{itemname: [a-zA-Z_0-9]*}")
    @Produces(value={"*/*"})
    public Response getItemData(@Context HttpHeaders headers, @PathParam(value="itemname") String itemname, @QueryParam(value="type") String type, @QueryParam(value="jsoncallback") @DefaultValue(value="callback") String callback) {
        logger.debug("Received HTTP GET request at '{}' for media type '{}'.", new Object[]{this.uriInfo.getPath(), type});
        String responseType = MediaTypeHelper.getResponseMediaType((List)headers.getAcceptableMediaTypes(), (String)type);
        if (responseType != null) {
            Object responseObject = responseType.equals("application/x-javascript") ? new JSONWithPadding((Object)this.getItemDataBean(itemname), callback) : this.getItemDataBean(itemname);
            throw new WebApplicationException(Response.ok((Object)responseObject, (String)responseType).build());
        }
        throw new WebApplicationException(Response.notAcceptable(null).build());
    }

    @PUT
    @Path(value="/{itemname: [a-zA-Z_0-9]*}/state")
    @Consumes(value={"text/plain"})
    public Response putItemState(@PathParam(value="itemname") String itemname, String value) {
        Item item = ItemResource.getItem(itemname);
        if (item != null) {
            State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)value);
            if (state != null) {
                logger.debug("Received HTTP PUT request at '{}' with value '{}'.", (Object)this.uriInfo.getPath(), (Object)value);
                RESTApplication.getEventPublisher().postUpdate(itemname, state);
                return Response.ok().build();
            }
            logger.warn("Received HTTP PUT request at '{}' with an invalid status value '{}'.", (Object)this.uriInfo.getPath(), (Object)value);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        logger.info("Received HTTP PUT request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
        throw new WebApplicationException(404);
    }

    @POST
    @Path(value="/{itemname: [a-zA-Z_0-9]*}")
    @Consumes(value={"text/plain"})
    public Response postItemCommand(@PathParam(value="itemname") String itemname, String value) {
        Item item = ItemResource.getItem(itemname);
        Command command = null;
        if (item != null) {
            if ("toggle".equalsIgnoreCase(value) && (item instanceof SwitchItem || item instanceof RollershutterItem)) {
                if (OnOffType.ON.equals((Object)item.getStateAs(OnOffType.class))) {
                    command = OnOffType.OFF;
                }
                if (OnOffType.OFF.equals((Object)item.getStateAs(OnOffType.class))) {
                    command = OnOffType.ON;
                }
                if (UpDownType.UP.equals((Object)item.getStateAs(UpDownType.class))) {
                    command = UpDownType.DOWN;
                }
                if (UpDownType.DOWN.equals((Object)item.getStateAs(UpDownType.class))) {
                    command = UpDownType.UP;
                }
            } else {
                command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)value);
            }
            if (command != null) {
                logger.debug("Received HTTP POST request at '{}' with value '{}'.", (Object)this.uriInfo.getPath(), (Object)value);
                RESTApplication.getEventPublisher().postCommand(itemname, command);
                return Response.created((URI)this.localUriInfo.getAbsolutePathBuilder().path("state").build(new Object[0])).build();
            }
            logger.warn("Received HTTP POST request at '{}' with an invalid status value '{}'.", (Object)this.uriInfo.getPath(), (Object)value);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        logger.info("Received HTTP POST request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
        throw new WebApplicationException(404);
    }

    public static ItemBean createItemBean(Item item, boolean drillDown, String uriPath) {
        ItemBean bean;
        if (item instanceof GroupItem && drillDown) {
            GroupItem groupItem = (GroupItem)item;
            GroupItemBean groupBean = new GroupItemBean();
            HashSet<ItemBean> members = new HashSet<ItemBean>();
            for (Item member : groupItem.getMembers()) {
                members.add(ItemResource.createItemBean(member, false, uriPath));
            }
            groupBean.members = members.toArray(new ItemBean[members.size()]);
            bean = groupBean;
        } else {
            bean = new ItemBean();
        }
        bean.name = item.getName();
        bean.state = item.getState().toString();
        bean.type = item.getClass().getSimpleName();
        bean.link = UriBuilder.fromUri((String)uriPath).path(PATH_ITEMS).path(bean.name).build(new Object[0]).toASCIIString();
        return bean;
    }

    public static Item getItem(String itemname) {
        ItemRegistry registry = RESTApplication.getItemRegistry();
        if (registry != null) {
            try {
                Item item = registry.getItem(itemname);
                return item;
            }
            catch (ItemNotFoundException e) {
                logger.debug(e.getMessage());
            }
        }
        return null;
    }

    private List<ItemBean> getItemBeans() {
        LinkedList<ItemBean> beans = new LinkedList<ItemBean>();
        ItemRegistry registry = RESTApplication.getItemRegistry();
        for (Item item : registry.getItems()) {
            beans.add(ItemResource.createItemBean(item, false, this.uriInfo.getBaseUri().toASCIIString()));
        }
        return beans;
    }

    private ItemBean getItemDataBean(String itemname) {
        Item item = ItemResource.getItem(itemname);
        if (item != null) {
            return ItemResource.createItemBean(item, true, this.uriInfo.getBaseUri().toASCIIString());
        }
        logger.info("Received HTTP GET request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
        throw new WebApplicationException(404);
    }
}

