/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sitemap.internal;

import com.sun.jersey.api.json.JSONWithPadding;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.rest.MediaTypeHelper;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.item.ItemResource;
import org.eclipse.smarthome.io.rest.sitemap.internal.beans.MappingBean;
import org.eclipse.smarthome.io.rest.sitemap.internal.beans.PageBean;
import org.eclipse.smarthome.io.rest.sitemap.internal.beans.SitemapBean;
import org.eclipse.smarthome.io.rest.sitemap.internal.beans.SitemapListBean;
import org.eclipse.smarthome.io.rest.sitemap.internal.beans.WidgetBean;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.sitemap.Chart;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.Image;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.Selection;
import org.eclipse.smarthome.model.sitemap.Setpoint;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.Slider;
import org.eclipse.smarthome.model.sitemap.Switch;
import org.eclipse.smarthome.model.sitemap.Video;
import org.eclipse.smarthome.model.sitemap.Webview;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="sitemaps")
public class SitemapResource
implements RESTResource {
    private static final Logger logger = LoggerFactory.getLogger(SitemapResource.class);
    protected static final String SITEMAP_FILEEXT = ".sitemap";
    public static final String PATH_SITEMAPS = "sitemaps";
    private static final long TIMEOUT_IN_MS = 30000L;
    @Context
    UriInfo uriInfo;
    private static ItemUIRegistry itemUIRegistry;
    private static ModelRepository modelRepository;

    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        SitemapResource.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        SitemapResource.itemUIRegistry = null;
    }

    public static ItemUIRegistry getItemUIRegistry() {
        return itemUIRegistry;
    }

    public void setModelRepository(ModelRepository modelRepository) {
        SitemapResource.modelRepository = modelRepository;
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        SitemapResource.modelRepository = null;
    }

    public static ModelRepository getModelRepository() {
        return modelRepository;
    }

    @GET
    @Produces(value={"*/*"})
    public Response getSitemaps(@Context HttpHeaders headers, @QueryParam(value="type") String type, @QueryParam(value="jsoncallback") @DefaultValue(value="callback") String callback) {
        logger.debug("Received HTTP GET request at '{}' for media type '{}'.", new Object[]{this.uriInfo.getPath(), type});
        String responseType = MediaTypeHelper.getResponseMediaType((List)headers.getAcceptableMediaTypes(), (String)type);
        if (responseType != null) {
            Object responseObject = responseType.equals("application/x-javascript") ? new JSONWithPadding((Object)new SitemapListBean(this.getSitemapBeans(this.uriInfo.getAbsolutePathBuilder().build(new Object[0]))), callback) : new SitemapListBean(this.getSitemapBeans(this.uriInfo.getAbsolutePathBuilder().build(new Object[0])));
            return Response.ok((Object)responseObject, (String)responseType).build();
        }
        return Response.notAcceptable(null).build();
    }

    @GET
    @Path(value="/{sitemapname: [a-zA-Z_0-9]*}")
    @Produces(value={"*/*"})
    public Response getSitemapData(@Context HttpHeaders headers, @PathParam(value="sitemapname") String sitemapname, @QueryParam(value="type") String type, @QueryParam(value="jsoncallback") @DefaultValue(value="callback") String callback) {
        logger.debug("Received HTTP GET request at '{}' for media type '{}'.", new Object[]{this.uriInfo.getPath(), type});
        String responseType = MediaTypeHelper.getResponseMediaType((List)headers.getAcceptableMediaTypes(), (String)type);
        if (responseType != null) {
            Object responseObject = responseType.equals("application/x-javascript") ? new JSONWithPadding((Object)this.getSitemapBean(sitemapname, this.uriInfo.getBaseUriBuilder().build(new Object[0])), callback) : this.getSitemapBean(sitemapname, this.uriInfo.getBaseUriBuilder().build(new Object[0]));
            return Response.ok((Object)responseObject, (String)responseType).build();
        }
        return Response.notAcceptable(null).build();
    }

    @GET
    @Path(value="/{sitemapname: [a-zA-Z_0-9]*}/{pageid: [a-zA-Z_0-9]*}")
    @Produces(value={"*/*"})
    public Response getPageData(@Context HttpHeaders headers, @PathParam(value="sitemapname") String sitemapname, @PathParam(value="pageid") String pageId, @QueryParam(value="type") String type, @QueryParam(value="jsoncallback") @DefaultValue(value="callback") String callback) {
        logger.debug("Received HTTP GET request at '{}' for media type '{}'.", new Object[]{this.uriInfo.getPath(), type});
        String responseType = MediaTypeHelper.getResponseMediaType((List)headers.getAcceptableMediaTypes(), (String)type);
        if (responseType != null) {
            if (headers.getRequestHeader("X-Atmosphere-Transport") != null) {
                this.blockUnlessChangeOccurs(sitemapname, pageId);
            }
            Object responseObject = responseType.equals("application/x-javascript") ? new JSONWithPadding((Object)SitemapResource.getPageBean(sitemapname, pageId, this.uriInfo.getBaseUriBuilder().build(new Object[0])), callback) : SitemapResource.getPageBean(sitemapname, pageId, this.uriInfo.getBaseUriBuilder().build(new Object[0]));
            return Response.ok((Object)responseObject, (String)responseType).build();
        }
        throw new WebApplicationException(Response.notAcceptable(null).build());
    }

    public static PageBean getPageBean(String sitemapName, String pageId, URI uri) {
        Sitemap sitemap = SitemapResource.getSitemap(sitemapName);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                return SitemapResource.createPageBean(sitemapName, sitemap.getLabel(), sitemap.getIcon(), sitemap.getName(), (EList<Widget>)sitemap.getChildren(), false, SitemapResource.isLeaf((EList<Widget>)sitemap.getChildren()), uri);
            }
            Widget pageWidget = itemUIRegistry.getWidget(sitemap, pageId);
            if (pageWidget instanceof LinkableWidget) {
                EList children = itemUIRegistry.getChildren((LinkableWidget)pageWidget);
                PageBean pageBean = SitemapResource.createPageBean(sitemapName, itemUIRegistry.getLabel(pageWidget), itemUIRegistry.getIcon(pageWidget), pageId, (EList<Widget>)children, false, SitemapResource.isLeaf((EList<Widget>)children), uri);
                EObject parentPage = pageWidget.eContainer();
                while (parentPage instanceof Frame) {
                    parentPage = parentPage.eContainer();
                }
                if (parentPage instanceof Widget) {
                    String parentId = itemUIRegistry.getWidgetId((Widget)parentPage);
                    pageBean.parent = SitemapResource.getPageBean(sitemapName, parentId, uri);
                    pageBean.parent.widgets = null;
                    pageBean.parent.parent = null;
                } else if (parentPage instanceof Sitemap) {
                    pageBean.parent = SitemapResource.getPageBean(sitemapName, sitemap.getName(), uri);
                    pageBean.parent.widgets = null;
                }
                return pageBean;
            }
            if (logger.isDebugEnabled()) {
                if (pageWidget == null) {
                    logger.debug("Received HTTP GET request at '{}' for the unknown page id '{}'.", (Object)uri, (Object)pageId);
                } else {
                    logger.debug("Received HTTP GET request at '{}' for the page id '{}'. This id refers to a non-linkable widget and is therefore no valid page id.", (Object)uri, (Object)pageId);
                }
            }
            throw new WebApplicationException(404);
        }
        logger.info("Received HTTP GET request at '{}' for the unknown sitemap '{}'.", (Object)uri, (Object)sitemapName);
        throw new WebApplicationException(404);
    }

    public Collection<SitemapBean> getSitemapBeans(URI uri) {
        LinkedList<SitemapBean> beans = new LinkedList<SitemapBean>();
        logger.debug("Received HTTP GET request at '{}'.", (Object)UriBuilder.fromUri((URI)uri).build(new Object[0]).toASCIIString());
        for (String modelName : modelRepository.getAllModelNamesOfType("sitemap")) {
            Sitemap sitemap = (Sitemap)modelRepository.getModel(modelName);
            if (sitemap == null) continue;
            SitemapBean bean = new SitemapBean();
            bean.name = StringUtils.removeEnd((String)modelName, (String)SITEMAP_FILEEXT);
            bean.icon = sitemap.getIcon();
            bean.label = sitemap.getLabel();
            bean.link = UriBuilder.fromUri((URI)uri).path(bean.name).build(new Object[0]).toASCIIString();
            bean.homepage = new PageBean();
            bean.homepage.link = String.valueOf(bean.link) + "/" + sitemap.getName();
            beans.add(bean);
        }
        return beans;
    }

    public SitemapBean getSitemapBean(String sitemapname, URI uri) {
        Sitemap sitemap = SitemapResource.getSitemap(sitemapname);
        if (sitemap != null) {
            return this.createSitemapBean(sitemapname, sitemap, uri);
        }
        logger.info("Received HTTP GET request at '{}' for the unknown sitemap '{}'.", (Object)this.uriInfo.getPath(), (Object)sitemapname);
        throw new WebApplicationException(404);
    }

    private SitemapBean createSitemapBean(String sitemapName, Sitemap sitemap, URI uri) {
        SitemapBean bean = new SitemapBean();
        bean.name = sitemapName;
        bean.icon = sitemap.getIcon();
        bean.label = sitemap.getLabel();
        bean.link = UriBuilder.fromUri((URI)uri).path(PATH_SITEMAPS).path(bean.name).build(new Object[0]).toASCIIString();
        bean.homepage = SitemapResource.createPageBean(sitemap.getName(), sitemap.getLabel(), sitemap.getIcon(), sitemap.getName(), (EList<Widget>)sitemap.getChildren(), true, false, uri);
        return bean;
    }

    private static PageBean createPageBean(String sitemapName, String title, String icon, String pageId, EList<Widget> children, boolean drillDown, boolean isLeaf, URI uri) {
        PageBean bean = new PageBean();
        bean.id = pageId;
        bean.title = title;
        bean.icon = icon;
        bean.leaf = isLeaf;
        bean.link = UriBuilder.fromUri((URI)uri).path(PATH_SITEMAPS).path(sitemapName).path(pageId).build(new Object[0]).toASCIIString();
        if (children != null) {
            int cntWidget = 0;
            for (Widget widget : children) {
                String widgetId;
                WidgetBean subWidget = SitemapResource.createWidgetBean(sitemapName, widget, drillDown, uri, widgetId = String.valueOf(pageId) + "_" + cntWidget);
                if (subWidget != null) {
                    bean.widgets.add(subWidget);
                }
                ++cntWidget;
            }
        } else {
            bean.widgets = null;
        }
        return bean;
    }

    private static WidgetBean createWidgetBean(String sitemapName, Widget widget, boolean drillDown, URI uri, String widgetId) {
        MappingBean mappingBean;
        Item item;
        if (!itemUIRegistry.getVisiblity(widget)) {
            return null;
        }
        WidgetBean bean = new WidgetBean();
        if (widget.getItem() != null && (item = ItemResource.getItem((String)widget.getItem())) != null) {
            bean.item = ItemResource.createItemBean((Item)item, (boolean)false, (String)UriBuilder.fromUri((URI)uri).build(new Object[0]).toASCIIString());
        }
        bean.widgetId = widgetId;
        bean.icon = itemUIRegistry.getIcon(widget);
        bean.labelcolor = itemUIRegistry.getLabelColor(widget);
        bean.valuecolor = itemUIRegistry.getValueColor(widget);
        bean.label = itemUIRegistry.getLabel(widget);
        bean.type = widget.eClass().getName();
        if (widget instanceof LinkableWidget) {
            LinkableWidget linkableWidget = (LinkableWidget)widget;
            EList children = itemUIRegistry.getChildren(linkableWidget);
            if (widget instanceof Frame) {
                int cntWidget = 0;
                for (Widget child : children) {
                    WidgetBean subWidget = SitemapResource.createWidgetBean(sitemapName, child, drillDown, uri, widgetId = String.valueOf(widgetId) + "_" + cntWidget);
                    if (subWidget == null) continue;
                    bean.widgets.add(subWidget);
                    ++cntWidget;
                }
            } else if (children.size() > 0) {
                String pageName = itemUIRegistry.getWidgetId((Widget)linkableWidget);
                bean.linkedPage = SitemapResource.createPageBean(sitemapName, itemUIRegistry.getLabel(widget), itemUIRegistry.getIcon(widget), pageName, (EList<Widget>)(drillDown ? children : null), drillDown, SitemapResource.isLeaf((EList<Widget>)children), uri);
            }
        }
        if (widget instanceof Switch) {
            Switch switchWidget = (Switch)widget;
            for (Mapping mapping : switchWidget.getMappings()) {
                mappingBean = new MappingBean();
                if (mapping.getCmd() != null) {
                    if (mapping.getCmd().startsWith("\"") && mapping.getCmd().endsWith("\"")) {
                        mappingBean.command = mapping.getCmd().substring(1, mapping.getCmd().length() - 1);
                    }
                } else {
                    mappingBean.command = mapping.getCmd();
                }
                mappingBean.label = mapping.getLabel();
                bean.mappings.add(mappingBean);
            }
        }
        if (widget instanceof Selection) {
            Selection selectionWidget = (Selection)widget;
            for (Mapping mapping : selectionWidget.getMappings()) {
                mappingBean = new MappingBean();
                if (mapping.getCmd() != null) {
                    if (mapping.getCmd().startsWith("\"") && mapping.getCmd().endsWith("\"")) {
                        mappingBean.command = mapping.getCmd().substring(1, mapping.getCmd().length() - 1);
                    }
                } else {
                    mappingBean.command = mapping.getCmd();
                }
                mappingBean.label = mapping.getLabel();
                bean.mappings.add(mappingBean);
            }
        }
        if (widget instanceof Slider) {
            Slider sliderWidget = (Slider)widget;
            bean.sendFrequency = sliderWidget.getFrequency();
            bean.switchSupport = sliderWidget.isSwitchEnabled();
        }
        if (widget instanceof org.eclipse.smarthome.model.sitemap.List) {
            org.eclipse.smarthome.model.sitemap.List listWidget = (org.eclipse.smarthome.model.sitemap.List)widget;
            bean.separator = listWidget.getSeparator();
        }
        if (widget instanceof Image) {
            Image imageWidget = (Image)widget;
            String wId = itemUIRegistry.getWidgetId(widget);
            bean.url = uri.getPort() < 0 || uri.getPort() == 80 ? String.valueOf(uri.getScheme()) + "://" + uri.getHost() + "/proxy?sitemap=" + sitemapName + ".sitemap&widgetId=" + wId : String.valueOf(uri.getScheme()) + "://" + uri.getHost() + ":" + uri.getPort() + "/proxy?sitemap=" + sitemapName + ".sitemap&widgetId=" + wId;
            if (imageWidget.getRefresh() > 0) {
                bean.refresh = imageWidget.getRefresh();
            }
        }
        if (widget instanceof Video) {
            String wId = itemUIRegistry.getWidgetId(widget);
            bean.url = uri.getPort() < 0 || uri.getPort() == 80 ? String.valueOf(uri.getScheme()) + "://" + uri.getHost() + "/proxy?sitemap=" + sitemapName + ".sitemap&widgetId=" + wId : String.valueOf(uri.getScheme()) + "://" + uri.getHost() + ":" + uri.getPort() + "/proxy?sitemap=" + sitemapName + ".sitemap&widgetId=" + wId;
        }
        if (widget instanceof Webview) {
            Webview webViewWidget = (Webview)widget;
            bean.url = webViewWidget.getUrl();
            bean.height = webViewWidget.getHeight();
        }
        if (widget instanceof Chart) {
            Chart chartWidget = (Chart)widget;
            bean.service = chartWidget.getService();
            bean.period = chartWidget.getPeriod();
            if (chartWidget.getRefresh() > 0) {
                bean.refresh = chartWidget.getRefresh();
            }
        }
        if (widget instanceof Setpoint) {
            Setpoint setpointWidget = (Setpoint)widget;
            bean.minValue = setpointWidget.getMinValue();
            bean.maxValue = setpointWidget.getMaxValue();
            bean.step = setpointWidget.getStep();
        }
        return bean;
    }

    private static boolean isLeaf(EList<Widget> children) {
        for (Widget w : children) {
            LinkableWidget linkableWidget;
            if (!(w instanceof Frame ? SitemapResource.isLeaf((EList<Widget>)((Frame)w).getChildren()) : w instanceof LinkableWidget && itemUIRegistry.getChildren(linkableWidget = (LinkableWidget)w).size() > 0)) continue;
            return false;
        }
        return true;
    }

    public static Sitemap getSitemap(String sitemapname) {
        if (modelRepository != null) {
            Sitemap sitemap = (Sitemap)modelRepository.getModel(String.valueOf(sitemapname) + SITEMAP_FILEEXT);
            return sitemap;
        }
        return null;
    }

    private void blockUnlessChangeOccurs(String sitemapname, String pageId) {
        Sitemap sitemap = SitemapResource.getSitemap(sitemapname);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                this.waitForChanges((EList<Widget>)sitemap.getChildren());
            } else {
                Widget pageWidget = itemUIRegistry.getWidget(sitemap, pageId);
                if (pageWidget instanceof LinkableWidget) {
                    EList children = itemUIRegistry.getChildren((LinkableWidget)pageWidget);
                    this.waitForChanges((EList<Widget>)children);
                }
            }
        }
    }

    private boolean waitForChanges(EList<Widget> widgets) {
        long startTime = new Date().getTime();
        boolean timeout = false;
        BlockingStateChangeListener listener = new BlockingStateChangeListener();
        Set<GenericItem> items = this.getAllItems(widgets);
        for (GenericItem item : items) {
            item.addStateChangeListener((StateChangeListener)listener);
        }
        while (!listener.hasChangeOccurred() && !timeout) {
            timeout = new Date().getTime() - startTime > 30000L;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                timeout = true;
                break;
            }
        }
        for (GenericItem item : items) {
            item.removeStateChangeListener((StateChangeListener)listener);
        }
        return !timeout;
    }

    private Set<GenericItem> getAllItems(EList<Widget> widgets) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        if (itemUIRegistry != null) {
            for (Widget widget : widgets) {
                String itemName = widget.getItem();
                if (itemName != null) {
                    try {
                        Item item = itemUIRegistry.getItem(itemName);
                        if (!(item instanceof GenericItem)) continue;
                        GenericItem gItem = (GenericItem)item;
                        items.add(gItem);
                    }
                    catch (ItemNotFoundException itemNotFoundException) {}
                    continue;
                }
                if (!(widget instanceof Frame)) continue;
                items.addAll(this.getAllItems((EList<Widget>)((Frame)widget).getChildren()));
            }
        }
        return items;
    }

    private static class BlockingStateChangeListener
    implements StateChangeListener {
        private boolean changed = false;

        private BlockingStateChangeListener() {
        }

        public void stateChanged(Item item, State oldState, State newState) {
            this.changed = true;
        }

        public boolean hasChangeOccurred() {
            return this.changed;
        }

        public void stateUpdated(Item item, State state) {
        }
    }
}

