/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest;

import java.util.List;
import javax.ws.rs.core.MediaType;

public class MediaTypeHelper {
    public static final String APPLICATION_X_JAVASCRIPT = "application/x-javascript";

    public static String getResponseMediaType(List<MediaType> acceptedTypes, String typeParam) {
        if ("xml".equals(typeParam)) {
            return "application/xml";
        }
        if ("json".equals(typeParam)) {
            return "application/json";
        }
        if ("jsonp".equals(typeParam)) {
            return APPLICATION_X_JAVASCRIPT;
        }
        for (MediaType type : acceptedTypes) {
            if (type.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                return "application/xml";
            }
            if (type.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                return "application/json";
            }
            if (!type.toString().equals(APPLICATION_X_JAVASCRIPT)) continue;
            return APPLICATION_X_JAVASCRIPT;
        }
        return null;
    }
}

