/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.io.mdns.MDNSService;
import org.eclipse.smarthome.io.mdns.ServiceDescription;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.internal.resources.RootResource;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="/rest")
public class RESTApplication
extends Application {
    public static final String REST_SERVLET_ALIAS = "/rest";
    private static final Logger logger = LoggerFactory.getLogger(RESTApplication.class);
    private int httpSSLPort;
    private int httpPort;
    private String mdnsName;
    private HttpService httpService;
    private MDNSService mdnsService;
    private static EventPublisher eventPublisher;
    private static ItemRegistry itemRegistry;
    private static List<RESTResource> restResources;

    static {
        restResources = new ArrayList<RESTResource>();
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        RESTApplication.eventPublisher = eventPublisher;
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        RESTApplication.eventPublisher = null;
    }

    public static EventPublisher getEventPublisher() {
        return eventPublisher;
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        RESTApplication.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        RESTApplication.itemRegistry = null;
    }

    public static ItemRegistry getItemRegistry() {
        return itemRegistry;
    }

    public void setMDNSService(MDNSService mdnsService) {
        this.mdnsService = mdnsService;
    }

    public void unsetMDNSService(MDNSService mdnsService) {
        this.mdnsService = null;
    }

    public void addRESTResource(RESTResource resource) {
        restResources.add(resource);
    }

    public void removeRESTResource(RESTResource resource) {
        restResources.remove(resource);
    }

    public void activate(BundleContext bundleContext) {
        block8: {
            try {
                ServletContainer servletContainer = new ServletContainer((Application)this);
                this.httpService.registerServlet(REST_SERVLET_ALIAS, (Servlet)servletContainer, this.getJerseyServletParams(), this.createHttpContext());
                logger.info("Started REST API at /rest");
                if (this.mdnsService == null) break block8;
                this.mdnsName = bundleContext.getProperty("mdnsName");
                if (this.mdnsName == null) {
                    this.mdnsName = "smarthome";
                }
                try {
                    this.httpPort = Integer.parseInt(bundleContext.getProperty("jetty.port"));
                    this.mdnsService.registerService(this.getDefaultServiceDescription());
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    this.httpSSLPort = Integer.parseInt(bundleContext.getProperty("jetty.port.ssl"));
                    this.mdnsService.registerService(this.getSSLServiceDescription());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (ServletException se) {
                throw new RuntimeException(se);
            }
            catch (NamespaceException se) {
                throw new RuntimeException(se);
            }
        }
    }

    public void deactivate() {
        if (this.httpService != null) {
            this.httpService.unregister(REST_SERVLET_ALIAS);
            logger.info("Stopped REST API");
        }
        if (this.mdnsService != null) {
            this.mdnsService.unregisterService(this.getDefaultServiceDescription());
            this.mdnsService.unregisterService(this.getSSLServiceDescription());
        }
        restResources.clear();
    }

    protected HttpContext createHttpContext() {
        HttpContext defaultHttpContext = this.httpService.createDefaultHttpContext();
        return defaultHttpContext;
    }

    public Set<Class<?>> getClasses() {
        HashSet result = new HashSet();
        result.add(RootResource.class);
        for (RESTResource resource : restResources) {
            result.add(resource.getClass());
        }
        return result;
    }

    public static List<RESTResource> getRestResources() {
        return restResources;
    }

    private Dictionary<String, String> getJerseyServletParams() {
        Hashtable<String, String> jerseyServletParams = new Hashtable<String, String>();
        ((Dictionary)jerseyServletParams).put("javax.ws.rs.Application", RESTApplication.class.getName());
        ((Dictionary)jerseyServletParams).put("com.sun.jersey.config.feature.XmlRootElementProcessing", "true");
        return jerseyServletParams;
    }

    private ServiceDescription getDefaultServiceDescription() {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        serviceProperties.put("uri", REST_SERVLET_ALIAS);
        return new ServiceDescription("_" + this.mdnsName + "-server._tcp.local.", this.mdnsName, this.httpPort, serviceProperties);
    }

    private ServiceDescription getSSLServiceDescription() {
        ServiceDescription description = this.getDefaultServiceDescription();
        description.serviceType = "_" + this.mdnsName + "-server-ssl._tcp.local.";
        description.serviceName = this.mdnsName + "-ssl";
        description.servicePort = this.httpSSLPort;
        return description;
    }
}

