/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import org.eclipse.smarthome.io.rest.MediaTypeHelper;

public class ResponseTypeHelper {
    public String getResponseType(HttpServletRequest request) {
        List<MediaType> mediaTypes = this.getAcceptedMediaTypes(request);
        String type = this.getQueryParam(request, "type");
        String responseType = MediaTypeHelper.getResponseMediaType(mediaTypes, type);
        return responseType;
    }

    protected List<MediaType> getAcceptedMediaTypes(HttpServletRequest request) {
        String[] acceptableMediaTypes = request.getHeader("Accept").split(",");
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(acceptableMediaTypes.length);
        String[] stringArray = acceptableMediaTypes;
        int n = acceptableMediaTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            MediaType mediaType = MediaType.valueOf((String)type.trim());
            if (mediaType != null) {
                mediaTypes.add(mediaType);
            }
            ++n2;
        }
        return mediaTypes;
    }

    public String getQueryParam(HttpServletRequest request, String paramName) {
        String[] pairs;
        if (request.getQueryString() == null) {
            return null;
        }
        String[] stringArray = pairs = request.getQueryString().split("&");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] keyValue = pair.split("=");
            if (keyValue[0].trim().equals(paramName)) {
                return keyValue[1].trim();
            }
            ++n2;
        }
        return null;
    }

    protected String getQueryParam(HttpServletRequest request, String paramName, String defaultValue) {
        String value = this.getQueryParam(request, paramName);
        return value != null ? value : defaultValue;
    }
}

