/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.internal.resources;

import com.sun.jersey.api.json.JSONWithPadding;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.io.rest.MediaTypeHelper;
import org.eclipse.smarthome.io.rest.RESTApplication;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.internal.resources.beans.RootBean;

@Path(value="/")
public class RootResource {
    @Context
    UriInfo uriInfo;

    @GET
    @Produces(value={"*/*"})
    public Response getRoot(@Context HttpHeaders headers, @QueryParam(value="type") String type, @QueryParam(value="jsoncallback") @DefaultValue(value="callback") String callback) {
        String responseType = MediaTypeHelper.getResponseMediaType(headers.getAcceptableMediaTypes(), type);
        if (responseType != null) {
            Object responseObject = responseType.equals("application/x-javascript") ? new JSONWithPadding((Object)this.getRootBean(), callback) : this.getRootBean();
            return Response.ok((Object)responseObject, (String)responseType).build();
        }
        return Response.notAcceptable(null).build();
    }

    private RootBean getRootBean() {
        RootBean bean = new RootBean();
        for (RESTResource resource : RESTApplication.getRestResources()) {
            String path = resource.getClass().getAnnotation(Path.class).value();
            bean.links.put(path, this.uriInfo.getBaseUriBuilder().path(path).build(new Object[0]).toASCIIString());
        }
        return bean;
    }
}

