/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageConsumer;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageProducer;
import org.eclipse.smarthome.io.transport.mqtt.MqttWillAndTestament;
import org.eclipse.smarthome.io.transport.mqtt.internal.MqttBrokerConnection;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttService
implements ManagedService {
    private static Logger logger = LoggerFactory.getLogger(MqttService.class);
    private ConcurrentHashMap<String, MqttBrokerConnection> brokerConnections = new ConcurrentHashMap();
    private EventPublisher eventPublisher;

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.equals("service.pid")) continue;
            String[] subkeys = key.split("\\.");
            if (subkeys.length != 2) {
                logger.debug("MQTT Broker property '{}' should have the format 'broker.propertykey'", (Object)key);
                continue;
            }
            String value = (String)properties.get(key);
            String name = subkeys[0].toLowerCase();
            String property = subkeys[1];
            if (StringUtils.isBlank((String)value)) {
                logger.trace("Property is empty: {}", (Object)key);
                continue;
            }
            logger.trace("Processing property: {} = {}", (Object)key, (Object)value);
            MqttBrokerConnection conn = this.brokerConnections.get(name);
            if (conn == null) {
                conn = new MqttBrokerConnection(name);
                this.brokerConnections.put(name, conn);
            }
            if (property.equals("url")) {
                conn.setUrl(value);
                continue;
            }
            if (property.equals("user")) {
                conn.setUser(value);
                continue;
            }
            if (property.equals("pwd")) {
                conn.setPassword(value);
                continue;
            }
            if (property.equals("qos")) {
                conn.setQos(Integer.parseInt(value));
                continue;
            }
            if (property.equals("retain")) {
                conn.setRetain(Boolean.parseBoolean(value));
                continue;
            }
            if (property.equals("async")) {
                conn.setAsync(Boolean.parseBoolean(value));
                continue;
            }
            if (property.equals("clientId")) {
                conn.setClientId(value);
                continue;
            }
            if (property.equals("lwt")) {
                MqttWillAndTestament will = MqttWillAndTestament.fromString(value);
                logger.debug("Setting last will: {}", (Object)will);
                conn.setLastWill(will);
                continue;
            }
            if (property.equals("keepAlive")) {
                conn.setKeepAliveInterval(Integer.parseInt(value));
                continue;
            }
            logger.warn("Unrecognized property: {}", (Object)key);
        }
        logger.info("MQTT Service initialization completed.");
        for (MqttBrokerConnection con : this.brokerConnections.values()) {
            try {
                con.start();
            }
            catch (Exception e) {
                logger.error("Error starting broker connection", (Throwable)e);
            }
        }
    }

    public void activate() {
        logger.debug("Starting MQTT Service...");
    }

    public void deactivate() {
        logger.debug("Stopping MQTT Service...");
        Enumeration<String> e = this.brokerConnections.keys();
        while (e.hasMoreElements()) {
            MqttBrokerConnection conn = this.brokerConnections.get(e.nextElement());
            logger.info("Stopping broker connection '{}'", (Object)conn.getName());
            conn.close();
        }
        logger.debug("MQTT Service stopped.");
    }

    private synchronized MqttBrokerConnection getConnection(String brokerName) {
        MqttBrokerConnection conn = this.brokerConnections.get(brokerName.toLowerCase());
        if (conn == null) {
            conn = new MqttBrokerConnection(brokerName);
            this.brokerConnections.put(brokerName.toLowerCase(), conn);
        }
        return conn;
    }

    public void registerMessageConsumer(String brokerName, MqttMessageConsumer mqttMessageConsumer) {
        mqttMessageConsumer.setEventPublisher(this.eventPublisher);
        this.getConnection(brokerName).addConsumer(mqttMessageConsumer);
    }

    public void unregisterMessageConsumer(String brokerName, MqttMessageConsumer mqttMessageConsumer) {
        this.getConnection(brokerName).removeConsumer(mqttMessageConsumer);
    }

    public void registerMessageProducer(String brokerName, MqttMessageProducer commandPublisher) {
        this.getConnection(brokerName).addProducer(commandPublisher);
    }

    public void unregisterMessageProducer(String brokerName, MqttMessageProducer commandPublisher) {
        this.getConnection(brokerName).removeProducer(commandPublisher);
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }
}

