/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt;

import org.apache.commons.lang.StringUtils;

public class MqttWillAndTestament {
    private String topic;
    private byte[] payload;
    private int qos = 0;
    private boolean retain = false;

    public static MqttWillAndTestament fromString(String string) {
        if (string == null) {
            return null;
        }
        MqttWillAndTestament result = new MqttWillAndTestament();
        String[] components = string.split(":");
        int i = 0;
        while (i < Math.min(components.length, 4)) {
            String value = StringUtils.trimToEmpty((String)components[i]);
            switch (i) {
                case 0: {
                    result.setTopic(value);
                    break;
                }
                case 1: {
                    result.setPayload(value.getBytes());
                    break;
                }
                case 2: {
                    if ("".equals(value)) break;
                    result.setQos(Integer.valueOf(value));
                    break;
                }
                case 3: {
                    result.setRetain(Boolean.valueOf(value));
                }
            }
            ++i;
        }
        return result;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        if (qos >= 0 && qos <= 2) {
            this.qos = qos;
        }
    }

    public boolean isRetain() {
        return this.retain;
    }

    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getClass());
        sb.append("] Send '");
        if (this.payload != null) {
            sb.append(new String(this.payload));
        } else {
            sb.append(this.payload);
        }
        sb.append("' to topic '");
        sb.append(this.topic);
        sb.append("'");
        if (this.retain) {
            sb.append(" retained");
        }
        sb.append(" using qos mode ").append(this.qos);
        return sb.toString();
    }
}

