/**
 * generated by Xtext
 */
package org.eclipse.smarthome.model.ui.contentassist;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.designer.ui.UIActivator;
import org.eclipse.smarthome.model.ui.contentassist.AbstractItemsProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
@SuppressWarnings("all")
public class ItemsProposalProvider extends AbstractItemsProposalProvider {
  protected final static Set<String> ITEMTYPES = CollectionLiterals.<String>newHashSet("Group", "Switch", "Number", "String", "Dimmer", "Color", "Contact", "Rollershutter", "DateTime");
  
  public void completeModelNormalItem_Type(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeModelNormalItem_Type(model, assignment, context, acceptor);
    for (final String itemType : ItemsProposalProvider.ITEMTYPES) {
      String _prefix = context.getPrefix();
      boolean _startsWith = itemType.startsWith(_prefix);
      if (_startsWith) {
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(itemType, context);
        acceptor.accept(_createCompletionProposal);
      }
    }
  }
  
  public void completeModelItem_Groups(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeModelItem_Groups(model, assignment, context, acceptor);
    ItemRegistry _service = UIActivator.itemRegistryTracker.getService();
    final ItemRegistry registry = ((ItemRegistry) _service);
    boolean _notEquals = (!Objects.equal(registry, null));
    if (_notEquals) {
      String _prefix = context.getPrefix();
      String _plus = (_prefix + "*");
      Collection<Item> _items = registry.getItems(_plus);
      for (final Item item : _items) {
        if ((item instanceof GroupItem)) {
          String _name = ((GroupItem)item).getName();
          final ICompletionProposal completionProposal = this.createCompletionProposal(_name, context);
          acceptor.accept(completionProposal);
        }
      }
    }
  }
}
