/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.rule.runtime.internal.engine;

import com.google.inject.Injector;
import com.google.inject.Provider;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.smarthome.core.scriptengine.ScriptEngine;
import org.eclipse.smarthome.core.scriptengine.ScriptExecutionException;
import org.eclipse.smarthome.model.rule.rules.Rule;
import org.eclipse.smarthome.model.rule.rules.RuleModel;
import org.eclipse.smarthome.model.rule.rules.VariableDeclaration;
import org.eclipse.smarthome.model.rule.runtime.internal.RuleRuntimeActivator;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleContextHelper {
    private static final Logger logger = LoggerFactory.getLogger(RuleContextHelper.class);

    public static synchronized IEvaluationContext getContext(Rule rule, Injector injector) {
        RuleModel ruleModel = (RuleModel)rule.eContainer();
        for (Adapter adapter : ruleModel.eAdapters()) {
            if (!(adapter instanceof RuleContextAdapter)) continue;
            return ((RuleContextAdapter)adapter).getContext();
        }
        Provider contextProvider = injector.getProvider(IEvaluationContext.class);
        ScriptEngine scriptEngine = (ScriptEngine)RuleRuntimeActivator.scriptEngineTracker.getService();
        if (scriptEngine != null) {
            IEvaluationContext evaluationContext = (IEvaluationContext)contextProvider.get();
            for (VariableDeclaration var : ruleModel.getVariables()) {
                try {
                    Object initialValue = var.getRight() == null ? null : scriptEngine.newScriptFromXExpression(var.getRight()).execute();
                    evaluationContext.newValue(QualifiedName.create((String)var.getName()), initialValue);
                }
                catch (ScriptExecutionException e) {
                    logger.warn("Variable '{}' on rule file '{}' cannot be initialized with value '{}': {}", new Object[]{var.getName(), ruleModel.eResource().getURI().path(), var.getRight().toString(), e.getMessage()});
                }
            }
            ruleModel.eAdapters().add((Object)new RuleContextAdapter(evaluationContext));
            return evaluationContext;
        }
        logger.debug("Rule variables of rule {} cannot be evaluated as no scriptengine is available!", (Object)ruleModel.eResource().getURI().path());
        return (IEvaluationContext)contextProvider.get();
    }

    private static class RuleContextAdapter
    extends EContentAdapter {
        private IEvaluationContext context;

        public RuleContextAdapter(IEvaluationContext context) {
            this.context = context;
        }

        public IEvaluationContext getContext() {
            return this.context;
        }
    }
}

