/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.scoping;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.scriptengine.action.ActionService;
import org.eclipse.smarthome.model.persistence.extensions.PersistenceExtensions;
import org.eclipse.smarthome.model.script.actions.BusEvent;
import org.eclipse.smarthome.model.script.actions.LogAction;
import org.eclipse.smarthome.model.script.actions.ScriptExecution;
import org.eclipse.smarthome.model.script.engine.IActionServiceProvider;
import org.eclipse.smarthome.model.script.lib.NumberExtensions;
import org.eclipse.xtext.xbase.scoping.batch.ImplicitlyImportedTypes;
import org.joda.time.DateTime;

@Singleton
public class ScriptImplicitlyImportedTypes
extends ImplicitlyImportedTypes {
    private List<Class<?>> actionClasses = null;
    @Inject
    IActionServiceProvider actionServiceProvider;

    protected List<Class<?>> getExtensionClasses() {
        List result = super.getExtensionClasses();
        result.remove(Comparable.class);
        result.remove(Double.class);
        result.remove(Integer.class);
        result.remove(BigInteger.class);
        result.remove(BigDecimal.class);
        result.remove(Double.TYPE);
        result.add(NumberExtensions.class);
        result.add(StringUtils.class);
        result.add(URLEncoder.class);
        result.add(PersistenceExtensions.class);
        result.add(BusEvent.class);
        return result;
    }

    protected List<Class<?>> getStaticImportClasses() {
        List result = super.getStaticImportClasses();
        result.add(BusEvent.class);
        result.add(ScriptExecution.class);
        result.add(LogAction.class);
        result.add(DateTime.class);
        result.addAll(this.getActionClasses());
        return result;
    }

    protected List<Class<?>> getActionClasses() {
        List services = (List)this.actionServiceProvider.get();
        if (services != null) {
            ArrayList localActionClasses = new ArrayList();
            for (ActionService actionService : services) {
                localActionClasses.add(actionService.getActionClass());
            }
            this.actionClasses = localActionClasses;
        }
        return this.actionClasses;
    }
}

