package org.eclipse.smarthome.model.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.model.services.SitemapGrammarAccess;
import org.eclipse.smarthome.model.sitemap.Chart;
import org.eclipse.smarthome.model.sitemap.ColorArray;
import org.eclipse.smarthome.model.sitemap.Colorpicker;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.Group;
import org.eclipse.smarthome.model.sitemap.Image;
import org.eclipse.smarthome.model.sitemap.List;
import org.eclipse.smarthome.model.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.Selection;
import org.eclipse.smarthome.model.sitemap.Setpoint;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapPackage;
import org.eclipse.smarthome.model.sitemap.Slider;
import org.eclipse.smarthome.model.sitemap.Switch;
import org.eclipse.smarthome.model.sitemap.Text;
import org.eclipse.smarthome.model.sitemap.Video;
import org.eclipse.smarthome.model.sitemap.VisibilityRule;
import org.eclipse.smarthome.model.sitemap.Webview;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

@SuppressWarnings("all")
public class SitemapSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private SitemapGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == SitemapPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case SitemapPackage.CHART:
				if(context == grammarAccess.getChartRule() ||
				   context == grammarAccess.getNonLinkableWidgetRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Chart(context, (Chart) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.COLOR_ARRAY:
				if(context == grammarAccess.getColorArrayRule()) {
					sequence_ColorArray(context, (ColorArray) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.COLORPICKER:
				if(context == grammarAccess.getColorpickerRule() ||
				   context == grammarAccess.getNonLinkableWidgetRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Colorpicker(context, (Colorpicker) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.FRAME:
				if(context == grammarAccess.getFrameRule()) {
					sequence_Frame(context, (Frame) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getLinkableWidgetRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Frame_LinkableWidget(context, (Frame) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.GROUP:
				if(context == grammarAccess.getGroupRule()) {
					sequence_Group(context, (Group) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getLinkableWidgetRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Group_LinkableWidget(context, (Group) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.IMAGE:
				if(context == grammarAccess.getImageRule()) {
					sequence_Image(context, (Image) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getLinkableWidgetRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Image_LinkableWidget(context, (Image) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.LIST:
				if(context == grammarAccess.getListRule() ||
				   context == grammarAccess.getNonLinkableWidgetRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_List(context, (List) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.MAPPING:
				if(context == grammarAccess.getMappingRule()) {
					sequence_Mapping(context, (Mapping) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.SELECTION:
				if(context == grammarAccess.getNonLinkableWidgetRule() ||
				   context == grammarAccess.getSelectionRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Selection(context, (Selection) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.SETPOINT:
				if(context == grammarAccess.getNonLinkableWidgetRule() ||
				   context == grammarAccess.getSetpointRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Setpoint(context, (Setpoint) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.SITEMAP:
				if(context == grammarAccess.getSitemapRule() ||
				   context == grammarAccess.getSitemapModelRule()) {
					sequence_Sitemap(context, (Sitemap) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.SLIDER:
				if(context == grammarAccess.getNonLinkableWidgetRule() ||
				   context == grammarAccess.getSliderRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Slider(context, (Slider) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.SWITCH:
				if(context == grammarAccess.getNonLinkableWidgetRule() ||
				   context == grammarAccess.getSwitchRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Switch(context, (Switch) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.TEXT:
				if(context == grammarAccess.getLinkableWidgetRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_LinkableWidget_Text(context, (Text) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getTextRule()) {
					sequence_Text(context, (Text) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.VIDEO:
				if(context == grammarAccess.getNonLinkableWidgetRule() ||
				   context == grammarAccess.getVideoRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Video(context, (Video) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.VISIBILITY_RULE:
				if(context == grammarAccess.getVisibilityRuleRule()) {
					sequence_VisibilityRule(context, (VisibilityRule) semanticObject); 
					return; 
				}
				else break;
			case SitemapPackage.WEBVIEW:
				if(context == grammarAccess.getNonLinkableWidgetRule() ||
				   context == grammarAccess.getWebviewRule() ||
				   context == grammarAccess.getWidgetRule()) {
					sequence_Webview(context, (Webview) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         service=STRING? 
	 *         refresh=INT? 
	 *         period=ID 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Chart(EObject context, Chart semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         (
	 *             item=ID? 
	 *             (
	 *                 condition='==' | 
	 *                 condition='>' | 
	 *                 condition='<' | 
	 *                 condition='>=' | 
	 *                 condition='<=' | 
	 *                 condition='!='
	 *             )? 
	 *             (sign='-' | sign='+')? 
	 *             state=XState
	 *         )? 
	 *         arg=STRING
	 *     )
	 */
	protected void sequence_ColorArray(EObject context, ColorArray semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         frequency=INT? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Colorpicker(EObject context, Colorpicker semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef? 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Frame(EObject context, Frame semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef? 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)? 
	 *         children+=Widget*
	 *     )
	 */
	protected void sequence_Frame_LinkableWidget(EObject context, Frame semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=GroupItemRef 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Group(EObject context, Group semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=GroupItemRef 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)? 
	 *         children+=Widget*
	 *     )
	 */
	protected void sequence_Group_LinkableWidget(EObject context, Group semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef? 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         url=STRING 
	 *         refresh=INT? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (IconColor+=ColorArray IconColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Image(EObject context, Image semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef? 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         url=STRING 
	 *         refresh=INT? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (IconColor+=ColorArray IconColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)? 
	 *         children+=Widget*
	 *     )
	 */
	protected void sequence_Image_LinkableWidget(EObject context, Image semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef? 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)? 
	 *         children+=Widget*
	 *     )
	 */
	protected void sequence_LinkableWidget_Text(EObject context, Text semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         separator=STRING 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_List(EObject context, List semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (cmd=Command (label=ID | label=STRING))
	 */
	protected void sequence_Mapping(EObject context, Mapping semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         (mappings+=Mapping mappings+=Mapping*)? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Selection(EObject context, Selection semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         minValue=Number? 
	 *         maxValue=Number? 
	 *         step=Number? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Setpoint(EObject context, Setpoint semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID label=STRING? icon=STRING? children+=Widget+)
	 */
	protected void sequence_Sitemap(EObject context, Sitemap semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         frequency=INT? 
	 *         switchEnabled?='switchSupport'? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Slider(EObject context, Slider semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         (mappings+=Mapping mappings+=Mapping*)? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Switch(EObject context, Switch semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef? 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Text(EObject context, Text semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef? 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         url=STRING 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Video(EObject context, Video semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ID 
	 *         (
	 *             condition='==' | 
	 *             condition='>' | 
	 *             condition='<' | 
	 *             condition='>=' | 
	 *             condition='<=' | 
	 *             condition='!='
	 *         ) 
	 *         (sign='-' | sign='+')? 
	 *         state=XState
	 *     )
	 */
	protected void sequence_VisibilityRule(EObject context, VisibilityRule semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         item=ItemRef? 
	 *         (label=ID | label=STRING)? 
	 *         icon=Icon? 
	 *         height=INT? 
	 *         url=STRING 
	 *         (LabelColor+=ColorArray LabelColor+=ColorArray*)? 
	 *         (ValueColor+=ColorArray ValueColor+=ColorArray*)? 
	 *         (Visibility+=VisibilityRule Visibility+=VisibilityRule*)?
	 *     )
	 */
	protected void sequence_Webview(EObject context, Webview semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
