/**
 * generated by Xtext
 */
package org.eclipse.smarthome.model.ui.contentassist;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.designer.core.config.ConfigurationFolderProvider;
import org.eclipse.smarthome.designer.ui.UIActivator;
import org.eclipse.smarthome.model.ui.contentassist.AbstractSitemapProposalProvider;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
@SuppressWarnings("all")
public class SitemapProposalProvider extends AbstractSitemapProposalProvider {
  /**
   * the image location inside the installation folder
   */
  protected final static String IMAGE_LOCATION = "../webapps/images/";
  
  public void complete_GroupItemRef(final EObject model, final RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.complete_GroupItemRef(model, ruleCall, context, acceptor);
    final ItemRegistry registry = UIActivator.itemRegistryTracker.getService();
    boolean _notEquals = (!Objects.equal(registry, null));
    if (_notEquals) {
      String _prefix = context.getPrefix();
      String _plus = (_prefix + "*");
      Collection<Item> _items = registry.getItems(_plus);
      for (final Item item : _items) {
        if ((item instanceof GroupItem)) {
          String _name = ((GroupItem)item).getName();
          final ICompletionProposal completionProposal = this.createCompletionProposal(_name, context);
          acceptor.accept(completionProposal);
        }
      }
    }
  }
  
  public void complete_ItemRef(final EObject model, final RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.complete_ItemRef(model, ruleCall, context, acceptor);
    final ItemRegistry registry = UIActivator.itemRegistryTracker.getService();
    boolean _notEquals = (!Objects.equal(registry, null));
    if (_notEquals) {
      String _prefix = context.getPrefix();
      String _plus = (_prefix + "*");
      Collection<Item> _items = registry.getItems(_plus);
      for (final Item item : _items) {
        {
          String _name = item.getName();
          final ICompletionProposal completionProposal = this.createCompletionProposal(_name, context);
          acceptor.accept(completionProposal);
        }
      }
    }
  }
  
  public void complete_Icon(final EObject model, final RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.complete_Icon(model, ruleCall, context, acceptor);
    try {
      IFolder _rootConfigurationFolder = ConfigurationFolderProvider.getRootConfigurationFolder();
      IPath _location = _rootConfigurationFolder.getLocation();
      File _file = _location.toFile();
      String _absolutePath = _file.getAbsolutePath();
      String _plus = (_absolutePath + File.separator);
      final String iconsFolder = (_plus + SitemapProposalProvider.IMAGE_LOCATION);
      final File folder = new File(iconsFolder);
      boolean _isDirectory = folder.isDirectory();
      if (_isDirectory) {
        String[] _list = folder.list();
        for (final String filename : _list) {
          String _lowerCase = filename.toLowerCase();
          boolean _endsWith = _lowerCase.endsWith(".png");
          if (_endsWith) {
            int _length = filename.length();
            int _minus = (_length - 4);
            String _substring = filename.substring(0, _minus);
            final ICompletionProposal completionProposal = this.createCompletionProposal(_substring, context);
            acceptor.accept(completionProposal);
          }
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof CoreException) {
        final CoreException e = (CoreException)_t;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
