/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.thing.valueconverter;

import java.math.BigDecimal;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class ValueTypeToStringConverter
implements IValueConverter<Object> {
    public Object toValue(String string, INode node) throws ValueConverterException {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            try {
                return Strings.convertFromJavaString((String)string.substring(1, string.length() - 1), (boolean)true);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }
        if (string.equals("true") || string.equals("false")) {
            return Boolean.valueOf(string);
        }
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Number expected.", node, (Exception)e);
        }
    }

    public String toString(Object value) throws ValueConverterException {
        if (value == null) {
            throw new ValueConverterException("Value may not be null.", null, null);
        }
        if (value instanceof String) {
            return this.toEscapedString((String)value);
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            return decimalValue.toPlainString();
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        throw new ValueConverterException("Unknown value type: " + value.getClass().getSimpleName(), null, null);
    }

    protected String toEscapedString(String value) {
        return String.valueOf('\"') + Strings.convertToJavaString((String)value, (boolean)false) + '\"';
    }
}

