/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.storage.mapdb;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.smarthome.core.storage.Storage;
import org.mapdb.DB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDbStorage<T>
implements Storage<T> {
    private static final String TYPE_SEPARATOR = "@@@";
    private static final Logger logger = LoggerFactory.getLogger(MapDbStorage.class);
    private DB db;
    private ClassLoader classLoader;
    private Map<String, String> map;
    private transient Gson mapper = new Gson();

    public MapDbStorage(DB db, String name, ClassLoader classLoader) {
        this.db = db;
        this.classLoader = classLoader;
        this.map = db.createTreeMap(name).makeOrGet();
    }

    public T put(String key, T value) {
        String previousValue = this.map.put(key, this.serialize(value));
        this.db.commit();
        return this.deserialize(previousValue);
    }

    public T remove(String key) {
        String removedElement = this.map.remove(key);
        this.db.commit();
        return this.deserialize(removedElement);
    }

    public T get(String key) {
        return this.deserialize(this.map.get(key));
    }

    public Collection<String> getKeys() {
        return this.map.keySet();
    }

    public Collection<T> getValues() {
        ArrayList<T> values = new ArrayList<T>();
        for (String key : this.getKeys()) {
            values.add(this.get(key));
        }
        return values;
    }

    private String serialize(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot serialize NULL");
        }
        String valueTypeName = value.getClass().getName();
        String valueAsString = this.mapper.toJson(value);
        String concatValue = String.valueOf(valueTypeName) + TYPE_SEPARATOR + valueAsString;
        logger.trace("serialized value '{}' to MapDB", (Object)concatValue);
        return concatValue;
    }

    public T deserialize(String json) {
        if (json == null) {
            return null;
        }
        String[] concatValue = json.split(TYPE_SEPARATOR);
        String valueTypeName = concatValue[0];
        String valueAsString = concatValue[1];
        Object value = null;
        try {
            Class<?> loadedValueType = null;
            loadedValueType = this.classLoader == null ? Class.forName(valueTypeName) : this.classLoader.loadClass(valueTypeName);
            value = this.mapper.fromJson(valueAsString, loadedValueType);
            logger.trace("deserialized value '{}' from MapDB", value);
        }
        catch (Exception e) {
            logger.warn("Couldn't deserialize value '{}'. Root cause is: {}", (Object)json, (Object)e.getMessage());
        }
        return (T)value;
    }
}

