/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class SyntheticBundleInstaller {
    private static Class<?> clazz = SyntheticBundleInstaller.class;
    private static String bundlePoolPath = "/test-bundle-pool";

    public static Bundle install(BundleContext bundleContext, String testBundleName) throws IOException, BundleException {
        String bundlePath = String.valueOf(bundlePoolPath) + "/" + testBundleName + "/";
        Path testbundleJar = SyntheticBundleInstaller.createSyntheticBundle(bundleContext, bundlePath, testBundleName);
        String location = testbundleJar.toUri().toString();
        Bundle bundle = bundleContext.installBundle(location);
        bundle.start(32);
        return bundle;
    }

    public static void uninstall(BundleContext bundleContext, String testBundleName) throws BundleException {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (testBundleName.equals(bundle.getSymbolicName())) {
                bundle.uninstall();
            }
            ++n2;
        }
    }

    private static Path createSyntheticBundle(BundleContext bundleContext, String bundlePath, String bundleName) throws IOException {
        Path testbundleJar = Files.createTempFile(String.valueOf(bundleName) + "-", ".jar", new FileAttribute[0]);
        testbundleJar.toFile().deleteOnExit();
        OutputStream outputStream = Files.newOutputStream(testbundleJar, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        List<String> files = SyntheticBundleInstaller.collectFilesFrom(bundleContext, bundlePath);
        for (String file : files) {
            SyntheticBundleInstaller.addFileToArchive(bundleContext, bundlePath, file, zipOutputStream);
        }
        zipOutputStream.close();
        outputStream.close();
        return testbundleJar;
    }

    private static void addFileToArchive(BundleContext bundleContext, String bundlePath, String fileInBundle, ZipOutputStream zipOutputStream) throws IOException {
        String filePath = String.valueOf(bundlePath) + "/" + fileInBundle;
        URL resource = bundleContext.getBundle().getResource(filePath);
        if (resource == null) {
            return;
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)resource.openStream());
        ZipEntry zipEntry = new ZipEntry(fileInBundle);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(bytes);
        zipOutputStream.closeEntry();
    }

    private static List<String> collectFilesFrom(BundleContext bundleContext, String resourceFolder) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("META-INF/MANIFEST.MF");
        result.add("ESH-INF/binding/binding.xml");
        result.add("ESH-INF/config/config.xml");
        result.add("ESH-INF/thing/thing-types.xml");
        return result;
    }
}

