/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.icon.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.smarthome.config.core.ConfigDispatcher;
import org.eclipse.smarthome.ui.icon.IconProvider;

public class DefaultIconProvider
implements IconProvider {
    public boolean hasIcon(String iconName) {
        File file = this.getIconFile(iconName);
        return file != null;
    }

    public InputStream getIcon(String iconName) {
        File file = this.getIconFile(iconName);
        if (file != null) {
            try {
                FileInputStream is = new FileInputStream(file);
                return is;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    private File getIconFile(String iconName) {
        File folder = new File(String.valueOf(ConfigDispatcher.getConfigFolder()) + File.separator + "icons");
        File file = new File(folder, String.valueOf(iconName) + ".png");
        if (file.exists()) {
            return file;
        }
        folder = new File("runtime" + File.separator + "icons");
        file = new File(folder, String.valueOf(iconName) + ".png");
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

