/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.icon.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconServlet
extends HttpServlet {
    private static final long serialVersionUID = 2880642275858634578L;
    private static final Logger logger = LoggerFactory.getLogger(IconServlet.class);
    private static final String SERVLET_NAME = "/images";
    private long startupTime;
    protected HttpService httpService;
    private List<IconProvider> iconProvider = new ArrayList<IconProvider>();

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    public void addIconProvider(IconProvider iconProvider) {
        this.iconProvider.add(iconProvider);
    }

    public void removeIconProvider(IconProvider iconProvider) {
        this.iconProvider.remove(iconProvider);
    }

    protected void activate() {
        try {
            logger.debug("Starting up icon servlet at /images");
            Hashtable props = new Hashtable();
            this.httpService.registerServlet(SERVLET_NAME, (Servlet)this, props, this.createHttpContext());
        }
        catch (NamespaceException e) {
            logger.error("Error during servlet startup", (Throwable)e);
        }
        catch (ServletException e) {
            logger.error("Error during servlet startup", (Throwable)e);
        }
        this.startupTime = System.currentTimeMillis();
    }

    protected HttpContext createHttpContext() {
        HttpContext defaultHttpContext = this.httpService.createDefaultHttpContext();
        return defaultHttpContext;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getDateHeader("If-Modified-Since") > this.startupTime) {
            resp.setStatus(304);
            return;
        }
        String filename = StringUtils.substringAfterLast((String)req.getRequestURI(), (String)"/");
        String iconName = StringUtils.substringBeforeLast((String)filename, (String)".");
        for (IconProvider provider : this.iconProvider) {
            if (!provider.hasIcon(iconName)) continue;
            resp.setContentType("image/png");
            resp.setDateHeader("Last-Modified", new Date().getTime());
            ServletOutputStream os = resp.getOutputStream();
            InputStream is = provider.getIcon(iconName);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            resp.flushBuffer();
            return;
        }
        resp.sendError(404);
    }
}

