/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.webapp.internal.render;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.eclipse.smarthome.ui.webapp.internal.WebAppActivator;
import org.eclipse.smarthome.ui.webapp.render.RenderException;
import org.eclipse.smarthome.ui.webapp.render.WidgetRenderer;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWidgetRenderer
implements WidgetRenderer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWidgetRenderer.class);
    protected static final String IMAGE_EXT = ".png";
    protected ItemUIRegistry itemUIRegistry;
    protected static final String SNIPPET_EXT = ".html";
    protected static final String SNIPPET_LOCATION = "snippets/";
    protected static final Map<String, String> snippetCache = new HashMap<String, String>();

    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    public ItemUIRegistry getItemUIRegistry() {
        return this.itemUIRegistry;
    }

    protected void activate(ComponentContext context) {
    }

    protected void deactivate(ComponentContext context) {
    }

    protected synchronized String getSnippet(String elementType) throws RenderException {
        String snippet = snippetCache.get(elementType = elementType.toLowerCase());
        if (snippet == null) {
            String snippetLocation = SNIPPET_LOCATION + elementType + SNIPPET_EXT;
            URL entry = WebAppActivator.getContext().getBundle().getEntry(snippetLocation);
            if (entry != null) {
                try {
                    snippet = IOUtils.toString((InputStream)entry.openStream());
                    snippetCache.put(elementType, snippet);
                }
                catch (IOException e) {
                    logger.warn("Cannot load snippet for element type '{}'", (Object)elementType, (Object)e);
                }
            } else {
                throw new RenderException("Cannot find a snippet for element type '" + elementType + "'");
            }
        }
        return snippet;
    }

    public String getLabel(Widget w) {
        String label = this.itemUIRegistry.getLabel(w);
        label = label.replaceAll("\\[", "<span style=\"%valuestyle%\">").replaceAll("\\]", "</span>");
        return label;
    }

    protected String escapeURLPath(String path) {
        try {
            return new URI(null, null, path, null).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.warn("Cannot escape path '{}' in URL. Returning unmodified path.", (Object)path);
            return path;
        }
    }

    protected String processColor(Widget w, String snippet) {
        String style = "";
        String color = this.itemUIRegistry.getLabelColor(w);
        if (color != null) {
            style = "color:" + color;
        }
        snippet = StringUtils.replace((String)snippet, (String)"%labelstyle%", (String)style);
        style = "";
        color = this.itemUIRegistry.getValueColor(w);
        if (color != null) {
            style = "color:" + color;
        }
        snippet = StringUtils.replace((String)snippet, (String)"%valuestyle%", (String)style);
        return snippet;
    }
}

