/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.internal.chart;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.ui.chart.ChartProvider;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartServlet
extends HttpServlet
implements ManagedService {
    private static final long serialVersionUID = 7700873790924746422L;
    private static final Logger logger = LoggerFactory.getLogger(ChartServlet.class);
    protected String providerName = "default";
    public static final String SERVLET_NAME = "/chart";
    protected static final Color[] LINECOLORS = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.ORANGE, Color.CYAN, Color.PINK, Color.DARK_GRAY, Color.YELLOW};
    protected static final Color[] AREACOLORS = new Color[]{new Color(255, 0, 0, 30), new Color(0, 255, 0, 30), new Color(0, 0, 255, 30), new Color(255, 0, 255, 30), new Color(255, 128, 0, 30), new Color(0, 255, 255, 30), new Color(255, 0, 128, 30), new Color(255, 128, 128, 30), new Color(255, 255, 0, 30)};
    protected static final Map<String, Long> PERIODS = new HashMap<String, Long>();
    protected HttpService httpService;
    protected ItemUIRegistry itemUIRegistry;
    protected static Map<String, ChartProvider> chartProviders;

    static {
        PERIODS.put("h", 3600000L);
        PERIODS.put("4h", 14400000L);
        PERIODS.put("8h", 28800000L);
        PERIODS.put("12h", 43200000L);
        PERIODS.put("D", 86400000L);
        PERIODS.put("3D", 259200000L);
        PERIODS.put("W", 604800000L);
        PERIODS.put("2W", 1209600000L);
        PERIODS.put("M", 2592000000L);
        PERIODS.put("2M", 5184000000L);
        PERIODS.put("4M", 10368000000L);
        PERIODS.put("Y", 31536000000L);
        chartProviders = new HashMap<String, ChartProvider>();
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    public void addChartProvider(ChartProvider provider) {
        chartProviders.put(provider.getName(), provider);
    }

    public void removeChartProvider(ChartProvider provider) {
        chartProviders.remove(provider.getName());
    }

    public static Map<String, ChartProvider> getChartProviders() {
        return chartProviders;
    }

    protected void activate() {
        try {
            logger.debug("Starting up chart servlet at /chart");
            Hashtable props = new Hashtable();
            this.httpService.registerServlet(SERVLET_NAME, (Servlet)this, props, this.createHttpContext());
        }
        catch (NamespaceException e) {
            logger.error("Error during chart servlet startup", (Throwable)e);
        }
        catch (ServletException e) {
            logger.error("Error during chart servlet startup", (Throwable)e);
        }
    }

    protected void deactivate() {
        this.httpService.unregister(SERVLET_NAME);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        logger.debug("Received incoming chart request: ", (Object)req);
        int width = 480;
        try {
            width = Integer.parseInt(req.getParameter("w"));
        }
        catch (Exception exception) {}
        int height = 240;
        try {
            height = Integer.parseInt(req.getParameter("h"));
        }
        catch (Exception exception) {}
        Long period = PERIODS.get(req.getParameter("period"));
        if (period == null) {
            period = PERIODS.get("D");
        }
        Date timeEnd = new Date();
        Date timeBegin = new Date(timeEnd.getTime() - period);
        String serviceName = req.getParameter("service");
        ChartProvider provider = ChartServlet.getChartProviders().get(this.providerName);
        if (provider == null) {
            throw new ServletException("Could not get chart provider.");
        }
        res.setContentType("image/" + (Object)((Object)provider.getChartType()));
        try {
            BufferedImage chart = provider.createChart(serviceName, null, timeBegin, timeEnd, height, width, req.getParameter("items"), req.getParameter("groups"));
            ImageIO.write((RenderedImage)chart, provider.getChartType().toString(), (OutputStream)res.getOutputStream());
        }
        catch (ItemNotFoundException itemNotFoundException) {
            logger.debug("Item not found error while generating chart.");
        }
        catch (IllegalArgumentException e) {
            logger.warn("Illegal argument in chart: {}", (Object)e.getMessage());
        }
    }

    protected HttpContext createHttpContext() {
        HttpContext defaultHttpContext = this.httpService.createDefaultHttpContext();
        return defaultHttpContext;
    }

    public void init(ServletConfig config) throws ServletException {
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletInfo() {
        return null;
    }

    public void destroy() {
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        if (properties.get("provider") != null) {
            this.providerName = (String)properties.get("provider");
        }
    }
}

