/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.internal.chart;

import com.xeiam.xchart.Chart;
import com.xeiam.xchart.ChartBuilder;
import com.xeiam.xchart.Series;
import com.xeiam.xchart.SeriesMarker;
import com.xeiam.xchart.StyleManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.ui.chart.ChartProvider;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChartProvider
implements ChartProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultChartProvider.class);
    protected static final Color[] LINECOLORS = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.ORANGE, Color.CYAN, Color.PINK, Color.DARK_GRAY, Color.YELLOW};
    protected static final Color[] AREACOLORS = new Color[]{new Color(255, 0, 0, 30), new Color(0, 255, 0, 30), new Color(0, 0, 255, 30), new Color(255, 0, 255, 30), new Color(255, 128, 0, 30), new Color(0, 255, 255, 30), new Color(255, 0, 128, 30), new Color(255, 128, 128, 30), new Color(255, 255, 0, 30)};
    protected ItemUIRegistry itemUIRegistry;
    protected static Map<String, QueryablePersistenceService> persistenceServices = new HashMap<String, QueryablePersistenceService>();
    private int legendPosition = 0;

    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    public void addPersistenceService(PersistenceService service) {
        if (service instanceof QueryablePersistenceService) {
            persistenceServices.put(service.getName(), (QueryablePersistenceService)service);
        }
    }

    public void removePersistenceService(PersistenceService service) {
        persistenceServices.remove(service.getName());
    }

    public static Map<String, QueryablePersistenceService> getPersistenceServices() {
        return persistenceServices;
    }

    protected void activate() {
        logger.debug("Starting up default chart provider.");
    }

    protected void deactivate() {
    }

    public void destroy() {
    }

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public BufferedImage createChart(String service, String theme, Date startTime, Date endTime, int height, int width, String items, String groups) throws ItemNotFoundException, IllegalArgumentException {
        Item item;
        int n;
        int n2;
        String[] stringArray;
        int seriesCounter = 0;
        Chart chart = new ChartBuilder().width(width).height(height).build();
        long period = (endTime.getTime() - startTime.getTime()) / 1000L;
        String pattern = "HH:mm";
        pattern = period <= 600L ? "mm:ss" : (period <= 86400L ? "HH:mm" : (period <= 604800L ? "EEE d" : "d MMM"));
        chart.getStyleManager().setDatePattern(pattern);
        chart.getStyleManager().setAxisTickLabelsFont(new Font("SansSerif", 0, 11));
        chart.getStyleManager().setChartPadding(5);
        chart.getStyleManager().setLegendBackgroundColor(Color.LIGHT_GRAY);
        chart.getStyleManager().setChartBackgroundColor(Color.LIGHT_GRAY);
        chart.getStyleManager().setXAxisMin((double)startTime.getTime());
        chart.getStyleManager().setXAxisMax((double)endTime.getTime());
        QueryablePersistenceService persistenceService = null;
        if (service != null) {
            persistenceService = DefaultChartProvider.getPersistenceServices().get(service);
        } else {
            Iterator<Map.Entry<String, QueryablePersistenceService>> it = DefaultChartProvider.getPersistenceServices().entrySet().iterator();
            if (it.hasNext()) {
                persistenceService = it.next().getValue();
            } else {
                throw new IllegalArgumentException("No Persistence service found.");
            }
        }
        if (persistenceService == null) {
            throw new IllegalArgumentException("Persistence service not found '" + service + "'.");
        }
        if (items != null) {
            String[] itemNames;
            stringArray = itemNames = items.split(",");
            n2 = itemNames.length;
            n = 0;
            while (n < n2) {
                String itemName = stringArray[n];
                item = this.itemUIRegistry.getItem(itemName);
                if (this.addItem(chart, persistenceService, startTime, endTime, item, seriesCounter)) {
                    ++seriesCounter;
                }
                ++n;
            }
        }
        if (groups != null) {
            String[] groupNames;
            stringArray = groupNames = groups.split(",");
            n2 = groupNames.length;
            n = 0;
            while (n < n2) {
                String groupName = stringArray[n];
                item = this.itemUIRegistry.getItem(groupName);
                if (item instanceof GroupItem) {
                    GroupItem groupItem = (GroupItem)item;
                    for (Item member : groupItem.getMembers()) {
                        if (!this.addItem(chart, persistenceService, startTime, endTime, member, seriesCounter)) continue;
                        ++seriesCounter;
                    }
                } else {
                    throw new ItemNotFoundException("Item '" + item.getName() + "' defined in groups is not a group.");
                }
                ++n;
            }
        }
        if (seriesCounter == 0) {
            chart.getStyleManager().setLegendVisible(false);
            ArrayList<Date> xData = new ArrayList<Date>();
            ArrayList<Integer> yData = new ArrayList<Integer>();
            xData.add(startTime);
            yData.add(0);
            xData.add(endTime);
            yData.add(0);
            Series series = chart.addDateSeries("NONE", xData, yData);
            series.setMarker(SeriesMarker.NONE);
            series.setLineStyle(new BasicStroke(0.0f));
        }
        if (this.legendPosition < 0) {
            chart.getStyleManager().setLegendPosition(StyleManager.LegendPosition.InsideNW);
        } else {
            chart.getStyleManager().setLegendPosition(StyleManager.LegendPosition.InsideSW);
        }
        BufferedImage lBufferedImage = new BufferedImage(chart.getWidth(), chart.getHeight(), 2);
        Graphics2D lGraphics2D = lBufferedImage.createGraphics();
        chart.paint(lGraphics2D);
        return lBufferedImage;
    }

    boolean addItem(Chart chart, QueryablePersistenceService service, Date timeBegin, Date timeEnd, Item item, int seriesCounter) {
        Color color = LINECOLORS[seriesCounter % LINECOLORS.length];
        String label = null;
        if (this.itemUIRegistry != null && (label = this.itemUIRegistry.getLabel(item.getName())) != null && label.contains("[") && label.contains("]")) {
            label = label.substring(0, label.indexOf(91));
        }
        if (label == null) {
            label = item.getName();
        }
        FilterCriteria filter = new FilterCriteria();
        filter.setBeginDate(timeBegin);
        filter.setEndDate(timeEnd);
        filter.setItemName(item.getName());
        filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
        Iterable result = service.query(filter);
        Iterator it = result.iterator();
        ArrayList<Date> xData = new ArrayList<Date>();
        ArrayList<Object> yData = new ArrayList<Object>();
        while (it.hasNext()) {
            HistoricItem historicItem = (HistoricItem)it.next();
            State state = historicItem.getState();
            if (!(state instanceof DecimalType)) continue;
            xData.add(historicItem.getTimestamp());
            yData.add((DecimalType)state);
        }
        if (xData.size() == 0) {
            return false;
        }
        if (xData.size() == 1) {
            xData.add((Date)xData.iterator().next());
            yData.add((Number)yData.iterator().next());
        }
        Series series = chart.addDateSeries(label, xData, yData);
        series.setLineStyle(new BasicStroke(1.5f));
        series.setMarker(SeriesMarker.NONE);
        series.setLineColor(color);
        this.legendPosition = ((Number)yData.iterator().next()).floatValue() > (series.getyMax().floatValue() - series.getyMin().floatValue()) / 2.0f + series.getyMin().floatValue() ? ++this.legendPosition : --this.legendPosition;
        return true;
    }

    @Override
    public ChartProvider.ImageType getChartType() {
        return ChartProvider.ImageType.png;
    }
}

