/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.internal.items;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.library.items.ColorItem;
import org.eclipse.smarthome.core.library.items.ContactItem;
import org.eclipse.smarthome.core.library.items.DimmerItem;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.items.RollershutterItem;
import org.eclipse.smarthome.core.library.items.StringItem;
import org.eclipse.smarthome.core.library.items.SwitchItem;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.model.sitemap.ColorArray;
import org.eclipse.smarthome.model.sitemap.Group;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapFactory;
import org.eclipse.smarthome.model.sitemap.Slider;
import org.eclipse.smarthome.model.sitemap.VisibilityRule;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.internal.UIActivator;
import org.eclipse.smarthome.ui.items.ItemUIProvider;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemUIRegistryImpl
implements ItemUIRegistry {
    private static final String ICON_NONE = "none";
    private static final Logger logger = LoggerFactory.getLogger(ItemUIRegistryImpl.class);
    protected static final String IMAGE_EXT = ".png";
    protected static final String IMAGE_LOCATION = "./webapps/images/";
    protected static final Pattern EXTRACT_TRANSFORMFUNCTION_PATTERN = Pattern.compile("\\[(.*?)\\((.*)\\):(.*)\\]");
    protected static final String IDENTIFY_FORMAT_PATTERN_PATTERN = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z])";
    protected Set<ItemUIProvider> itemUIProviders = new HashSet<ItemUIProvider>();
    private List<IconProvider> iconProviders = new ArrayList<IconProvider>();
    protected ItemRegistry itemRegistry;

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    public void addItemUIProvider(ItemUIProvider itemUIProvider) {
        this.itemUIProviders.add(itemUIProvider);
    }

    public void removeItemUIProvider(ItemUIProvider itemUIProvider) {
        this.itemUIProviders.remove(itemUIProvider);
    }

    public void addIconProvider(IconProvider iconProvider) {
        this.iconProviders.add(iconProvider);
    }

    public void removeIconProvider(IconProvider iconProvider) {
        this.iconProviders.remove(iconProvider);
    }

    @Override
    public String getIcon(String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            String currentIcon = provider.getIcon(itemName);
            if (currentIcon == null) continue;
            return currentIcon;
        }
        Class<? extends Item> itemType = this.getItemType(itemName);
        if (itemType == null) {
            return null;
        }
        if (itemType.equals(NumberItem.class) || itemType.equals(ContactItem.class) || itemType.equals(RollershutterItem.class)) {
            return itemType.getSimpleName().replace("Item", "").toLowerCase();
        }
        return null;
    }

    @Override
    public String getLabel(String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            String currentLabel = provider.getLabel(itemName);
            if (currentLabel == null) continue;
            return currentLabel;
        }
        return null;
    }

    @Override
    public Widget getWidget(String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            Widget currentWidget = provider.getWidget(itemName);
            if (currentWidget == null) continue;
            return currentWidget;
        }
        return null;
    }

    @Override
    public Widget getDefaultWidget(Class<? extends Item> itemType, String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            Widget widget = provider.getDefaultWidget(itemType, itemName);
            if (widget == null) continue;
            return widget;
        }
        if (itemType == null) {
            itemType = this.getItemType(itemName);
        }
        if (itemType == null) {
            return null;
        }
        if (itemType.equals(SwitchItem.class)) {
            return SitemapFactory.eINSTANCE.createSwitch();
        }
        if (itemType.equals(GroupItem.class)) {
            return SitemapFactory.eINSTANCE.createGroup();
        }
        if (NumberItem.class.isAssignableFrom(itemType)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (itemType.equals(ContactItem.class)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (itemType.equals(RollershutterItem.class)) {
            return SitemapFactory.eINSTANCE.createSwitch();
        }
        if (itemType.equals(StringItem.class)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (itemType.equals(DimmerItem.class)) {
            Slider slider = SitemapFactory.eINSTANCE.createSlider();
            slider.setSwitchEnabled(true);
            return slider;
        }
        if (itemType.equals(ColorItem.class)) {
            return SitemapFactory.eINSTANCE.createColorpicker();
        }
        return null;
    }

    @Override
    public String getLabel(Widget w) {
        String label = this.getLabelFromWidget(w);
        String itemName = w.getItem();
        if (itemName != null && label.contains("[")) {
            int indexOpenBracket = label.indexOf("[");
            int indexCloseBracket = label.indexOf("]");
            State state = null;
            String formatPattern = label.substring(indexOpenBracket + 1, indexCloseBracket);
            try {
                Item item = this.getItem(itemName);
                if (label.contains("%d")) {
                    state = item.getState();
                    if (!(state instanceof DecimalType)) {
                        state = item.getStateAs(DecimalType.class);
                    }
                } else {
                    state = item.getState();
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                logger.error("Cannot retrieve item for widget {}", (Object)w.eClass().getInstanceTypeName());
            }
            if (state == null || state instanceof UnDefType) {
                formatPattern = this.formatUndefined(formatPattern);
            } else if (state instanceof Type) {
                try {
                    formatPattern = state.format(formatPattern);
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Exception while formatting value '{}' of item {} with format '{}': {}", new Object[]{state, itemName, formatPattern, e});
                    formatPattern = new String("Err");
                }
            }
            label = String.valueOf(label.substring(0, indexOpenBracket + 1)) + formatPattern + label.substring(indexCloseBracket);
        }
        label = this.transform(label);
        return label;
    }

    private String getLabelFromWidget(Widget w) {
        String label = null;
        if (w.getLabel() != null) {
            label = w.getLabel();
        } else {
            String itemName = w.getItem();
            if (itemName != null && (label = this.getLabel(itemName)) == null) {
                label = itemName;
            }
        }
        return label != null ? label : "";
    }

    protected String formatUndefined(String formatPattern) {
        String undefinedFormatPattern = formatPattern.replaceAll(IDENTIFY_FORMAT_PATTERN_PATTERN, "%1\\$s");
        try {
            return String.format(undefinedFormatPattern, "-");
        }
        catch (Exception e) {
            logger.warn("Exception while formatting undefined value [sourcePattern={}, targetPattern={}, {}]", new Object[]{formatPattern, undefinedFormatPattern, e});
            return "Err";
        }
    }

    private String transform(String label) {
        Matcher matcher;
        if (label.contains("[") && label.endsWith("]") && (matcher = EXTRACT_TRANSFORMFUNCTION_PATTERN.matcher(label)).find()) {
            String type = matcher.group(1);
            String pattern = matcher.group(2);
            String value = matcher.group(3);
            TransformationService transformation = TransformationHelper.getTransformationService((BundleContext)UIActivator.getContext(), (String)type);
            if (transformation != null) {
                try {
                    label = String.valueOf(label.substring(0, label.indexOf("[") + 1)) + transformation.transform(pattern, value) + "]";
                }
                catch (TransformationException e) {
                    logger.error("transformation throws exception [transformation=" + transformation + ", value=" + value + "]", (Throwable)e);
                    label = String.valueOf(label.substring(0, label.indexOf("[") + 1)) + value + "]";
                }
            } else {
                logger.warn("couldn't transform value in label because transformationService of type '{}' is unavailable", (Object)type);
                label = String.valueOf(label.substring(0, label.indexOf("[") + 1)) + value + "]";
            }
        }
        return label;
    }

    @Override
    public String getIcon(Widget w) {
        State state;
        String widgetTypeName = w.eClass().getInstanceTypeName().substring(w.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
        String icon = widgetTypeName.toLowerCase();
        if (w.getIcon() != null) {
            icon = w.getIcon();
        } else {
            String result;
            String itemName = w.getItem();
            if (itemName != null && (result = this.getIcon(itemName)) != null) {
                icon = result;
            }
        }
        if (!icon.contains("-") && !(state = this.getState(w)).equals(UnDefType.UNDEF)) {
            if (state instanceof PercentType) {
                String testIcon;
                int iconState = ((PercentType)state).toBigDecimal().intValue();
                while (!this.iconExists(testIcon = String.valueOf(icon) + "-" + String.valueOf(iconState--)) && iconState >= 0) {
                }
                icon = testIcon;
            } else {
                icon = String.valueOf(icon) + "-" + state.toString().toLowerCase();
            }
        }
        if (this.iconExists(icon) || !icon.contains("-")) {
            return icon;
        }
        if (this.iconExists(icon = icon.substring(0, icon.indexOf("-")))) {
            return icon;
        }
        return ICON_NONE;
    }

    @Override
    public State getState(Widget w) {
        String itemName = w.getItem();
        if (itemName != null) {
            try {
                Item item = this.getItem(itemName);
                return item.getState();
            }
            catch (ItemNotFoundException itemNotFoundException) {
                logger.error("Cannot retrieve item '{}' for widget {}", (Object[])new String[]{itemName, w.eClass().getInstanceTypeName()});
            }
        }
        return UnDefType.UNDEF;
    }

    @Override
    public Widget getWidget(Sitemap sitemap, String id) {
        if (id.length() > 0) {
            Widget w = this.getWidget(id);
            if (w == null) {
                w = this.getDefaultWidget(null, id);
            }
            if (w != null) {
                w.setItem(id);
                return w;
            }
            try {
                w = (Widget)sitemap.getChildren().get(Integer.valueOf(id.substring(0, 2)).intValue());
                int i = 2;
                while (i < id.length()) {
                    w = (Widget)((LinkableWidget)w).getChildren().get(Integer.valueOf(id.substring(i, i + 2)).intValue());
                    i += 2;
                }
                return w;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        logger.warn("Cannot find page for id '{}'.", (Object)id);
        return null;
    }

    @Override
    public EList<Widget> getChildren(LinkableWidget w) {
        if (w instanceof Group && w.getChildren().isEmpty()) {
            return this.getDynamicGroupChildren((Group)w);
        }
        return w.getChildren();
    }

    private EList<Widget> getDynamicGroupChildren(Group group) {
        BasicEList children = new BasicEList();
        String itemName = group.getItem();
        try {
            Item item = this.getItem(itemName);
            if (item instanceof GroupItem) {
                GroupItem groupItem = (GroupItem)item;
                for (Item member : groupItem.getMembers()) {
                    Widget widget = this.getDefaultWidget(member.getClass(), member.getName());
                    if (widget == null) continue;
                    widget.setItem(member.getName());
                    children.add((Object)widget);
                }
            } else {
                logger.warn("Item '{}' is not a group.", (Object)item.getName());
            }
        }
        catch (ItemNotFoundException e) {
            logger.warn("Group '{}' could not be found.", (Object)group.getLabel(), (Object)e);
        }
        return children;
    }

    @Override
    public boolean iconExists(String icon) {
        for (IconProvider provider : this.iconProviders) {
            if (!provider.hasIcon(icon)) continue;
            return true;
        }
        return false;
    }

    private Class<? extends Item> getItemType(String itemName) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            return item.getClass();
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return null;
        }
    }

    @Override
    public State getItemState(String itemName) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            return item.getState();
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return null;
        }
    }

    public Item getItem(String name) throws ItemNotFoundException {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItem(name);
        }
        return null;
    }

    public Item getItemByPattern(String name) throws ItemNotFoundException, ItemNotUniqueException {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItemByPattern(name);
        }
        return null;
    }

    public Collection<Item> getItems() {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItems();
        }
        return Collections.emptyList();
    }

    public Collection<Item> getItems(String pattern) {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItems(pattern);
        }
        return Collections.emptyList();
    }

    public boolean isValidItemName(String itemName) {
        if (this.itemRegistry != null) {
            return this.itemRegistry.isValidItemName(itemName);
        }
        return false;
    }

    public void addRegistryChangeListener(RegistryChangeListener<Item> listener) {
        if (this.itemRegistry != null) {
            this.itemRegistry.addRegistryChangeListener(listener);
        }
    }

    public void removeRegistryChangeListener(RegistryChangeListener<Item> listener) {
        if (this.itemRegistry != null) {
            this.itemRegistry.removeRegistryChangeListener(listener);
        }
    }

    public Collection<Item> getAll() {
        return this.itemRegistry.getAll();
    }

    @Override
    public String getWidgetId(Widget w) {
        String index;
        String id = "";
        while (w.eContainer() instanceof Widget) {
            Widget parent = (Widget)w.eContainer();
            index = String.valueOf(((LinkableWidget)parent).getChildren().indexOf((Object)w));
            if (index.length() == 1) {
                index = "0" + index;
            }
            id = String.valueOf(index) + id;
            w = parent;
        }
        if (w.eContainer() instanceof Sitemap) {
            Sitemap sitemap = (Sitemap)w.eContainer();
            index = String.valueOf(sitemap.getChildren().indexOf((Object)w));
            if (index.length() == 1) {
                index = "0" + index;
            }
            id = String.valueOf(index) + id;
        }
        if (w.eContainer() == null) {
            String itemName;
            id = itemName = w.getItem();
        }
        return id;
    }

    private boolean matchStateToValue(State state, String value, String matchCondition) {
        boolean matched = false;
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        Condition condition = Condition.EQUAL;
        if (matchCondition != null) {
            condition = Condition.fromString(matchCondition);
        }
        if (DecimalType.class.isInstance(state)) {
            try {
                switch (condition) {
                    case EQUAL: {
                        if (Double.parseDouble(state.toString()) == Double.parseDouble(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case LTE: {
                        if (Double.parseDouble(state.toString()) <= Double.parseDouble(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case GTE: {
                        if (Double.parseDouble(state.toString()) >= Double.parseDouble(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case GREATER: {
                        if (Double.parseDouble(state.toString()) > Double.parseDouble(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case LESS: {
                        if (Double.parseDouble(state.toString()) < Double.parseDouble(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case NOTEQUAL: 
                    case NOT: {
                        if (Double.parseDouble(state.toString()) == Double.parseDouble(value)) break;
                        matched = true;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                logger.debug("matchStateToValue: Decimal format exception: " + e);
            }
        } else if (state instanceof DateTimeType) {
            Calendar val = ((DateTimeType)state).getCalendar();
            Calendar now = Calendar.getInstance();
            long secsDif = (now.getTimeInMillis() - val.getTimeInMillis()) / 1000L;
            try {
                switch (condition) {
                    case EQUAL: {
                        if (secsDif == (long)Integer.parseInt(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case LTE: {
                        if (secsDif <= (long)Integer.parseInt(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case GTE: {
                        if (secsDif >= (long)Integer.parseInt(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case GREATER: {
                        if (secsDif > (long)Integer.parseInt(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case LESS: {
                        if (secsDif < (long)Integer.parseInt(value)) {
                            matched = true;
                        }
                        break;
                    }
                    case NOTEQUAL: 
                    case NOT: {
                        if (secsDif == (long)Integer.parseInt(value)) break;
                        matched = true;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                logger.debug("matchStateToValue: Decimal format exception: " + e);
            }
        } else {
            switch (condition) {
                case NOTEQUAL: 
                case NOT: {
                    if (value.equals(state.toString())) break;
                    matched = true;
                    break;
                }
                default: {
                    if (!value.equals(state.toString())) break;
                    matched = true;
                }
            }
        }
        return matched;
    }

    private String processColorDefinition(State state, List<ColorArray> colorList) {
        if (colorList == null) {
            return null;
        }
        if (colorList.size() == 0) {
            return null;
        }
        String colorString = null;
        if (colorList.size() == 1 && colorList.get(0).getState() == null) {
            colorString = colorList.get(0).getArg();
        } else {
            for (ColorArray color : colorList) {
                String value;
                State cmpState = state;
                if (color.getState() == null) {
                    logger.error("Error parsing color");
                    continue;
                }
                if (color.getItem() != null) {
                    try {
                        Item item = this.itemRegistry.getItem(color.getItem());
                        cmpState = item.getState();
                    }
                    catch (ItemNotFoundException itemNotFoundException) {
                        logger.warn("Cannot retrieve color item {} for widget", (Object)color.getItem());
                    }
                }
                if (!this.matchStateToValue(cmpState, value = color.getSign() != null ? String.valueOf(color.getSign()) + color.getState() : color.getState(), color.getCondition())) continue;
                colorString = color.getArg();
                break;
            }
        }
        if (colorString == null) {
            return null;
        }
        if (colorString.startsWith("\"") && colorString.endsWith("\"")) {
            colorString = colorString.substring(1, colorString.length() - 1);
        }
        return colorString;
    }

    @Override
    public String getLabelColor(Widget w) {
        return this.processColorDefinition(this.getState(w), (List<ColorArray>)w.getLabelColor());
    }

    @Override
    public String getValueColor(Widget w) {
        return this.processColorDefinition(this.getState(w), (List<ColorArray>)w.getValueColor());
    }

    @Override
    public boolean getVisiblity(Widget w) {
        EList ruleList = w.getVisibility();
        if (ruleList == null) {
            return true;
        }
        if (ruleList.size() == 0) {
            return true;
        }
        logger.debug("Checking visiblity for widget '{}'.", (Object)w.getLabel());
        for (VisibilityRule rule : w.getVisibility()) {
            Item item;
            if (rule.getItem() == null || rule.getState() == null) continue;
            try {
                item = this.itemRegistry.getItem(rule.getItem());
            }
            catch (ItemNotFoundException itemNotFoundException) {
                logger.error("Cannot retrieve visibility item {} for widget {}", (Object)rule.getItem(), (Object)w.eClass().getInstanceTypeName());
                return true;
            }
            State state = item.getState();
            String value = rule.getSign() != null ? String.valueOf(rule.getSign()) + rule.getState() : rule.getState();
            if (!this.matchStateToValue(state, value, rule.getCondition())) continue;
            return true;
        }
        logger.debug("Widget {} is not visible.", (Object)w.getLabel());
        return false;
    }

    static enum Condition {
        EQUAL("=="),
        GTE(">="),
        LTE("<="),
        NOTEQUAL("!="),
        GREATER(">"),
        LESS("<"),
        NOT("!");

        private String value;

        private Condition(String value) {
            this.value = value;
        }

        public static Condition fromString(String text) {
            if (text != null) {
                Condition[] conditionArray = Condition.values();
                int n = conditionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Condition c = conditionArray[n2];
                    if (text.equalsIgnoreCase(c.value)) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

