/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.RuleEngine;
import org.eclipse.smarthome.automation.core.internal.RuntimeRule;
import org.eclipse.smarthome.automation.handler.RuleEngineCallback;

public class RuleEngineCallbackImpl
implements RuleEngineCallback {
    private RuntimeRule r;
    private ExecutorService executor;
    private Future<?> feature;
    private RuleEngine re;

    protected RuleEngineCallbackImpl(RuleEngine re, RuntimeRule r) {
        this.re = re;
        this.r = r;
        this.executor = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggered(Trigger trigger, Map<String, ?> outputs) {
        if (this.executor != null) {
            this.re.logger.debug("The trigger '{}' of rule '{}' is triggred.", (Object)trigger.getId(), (Object)this.r.getUID());
            ExecutorService executorService = this.executor;
            synchronized (executorService) {
                if (this.executor != null) {
                    this.feature = this.executor.submit(new TriggerData(trigger, outputs));
                }
            }
        }
    }

    public Rule getRule() {
        return this.r;
    }

    public boolean isRunning() {
        return this.feature == null || !this.feature.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        this.r = null;
    }

    class TriggerData
    implements Runnable {
        private Trigger trigger;
        private Map<String, ?> outputs;

        public Trigger getTrigger() {
            return this.trigger;
        }

        public Map<String, ?> getOutputs() {
            return this.outputs;
        }

        public TriggerData(Trigger t, Map<String, ?> outputs) {
            this.trigger = t;
            this.outputs = outputs;
        }

        @Override
        public void run() {
            RuleEngineCallbackImpl.this.re.runRule(RuleEngineCallbackImpl.this.r, this);
        }
    }
}

