/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.Collection;
import java.util.Set;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.StatusInfoCallback;
import org.eclipse.smarthome.automation.core.internal.RuleEngine;
import org.eclipse.smarthome.automation.events.RuleEventFactory;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleRegistryImpl
extends AbstractRegistry<Rule, String>
implements RuleRegistry,
StatusInfoCallback {
    private RuleEngine ruleEngine;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Storage<Boolean> disabledRulesStorage;
    private static final String SOURCE = RuleRegistryImpl.class.getSimpleName();

    public RuleRegistryImpl(RuleEngine ruleEngine) {
        this.ruleEngine = ruleEngine;
        ruleEngine.setStatusInfoCallback(this);
    }

    protected void addProvider(Provider<Rule> provider) {
        this.logger.info("Rule provider: {} is added.", provider);
        super.addProvider(provider);
    }

    protected void setManagedProvider(ManagedProvider<Rule, String> provider) {
        super.setManagedProvider(provider);
        this.logger.info("Rule Managed Provider: {} is added.", provider);
    }

    protected void removeProvider(Provider<Rule> provider) {
        this.logger.info("Rule provider: {} is removed.", provider);
        super.removeProvider(provider);
    }

    protected void removeManagedProvider(ManagedProvider<Rule, String> provider) {
        super.removeManagedProvider(provider);
        this.logger.info("Rule Managed provider: {} is removed.", provider);
    }

    public Rule add(Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("The added rule must not be null!");
        }
        String rUID = rule.getUID();
        Rule ruleWithUID = rUID == null ? this.ruleEngine.initRuleId(rule) : rule;
        super.add((Object)ruleWithUID);
        return ruleWithUID;
    }

    protected void onAddElement(Rule rule) throws IllegalArgumentException {
        try {
            String rUID = rule.getUID();
            if (rUID != null && this.disabledRulesStorage != null && this.disabledRulesStorage.get(rUID) != null) {
                this.ruleEngine.addRule(rule, false);
            } else {
                this.ruleEngine.addRule(rule, true);
            }
            super.onAddElement((Object)rule);
            this.postEvent((Event)RuleEventFactory.createRuleAddedEvent((Rule)rule, (String)SOURCE));
        }
        catch (Exception e) {
            this.logger.error("Can't add rule: {}", (Object)rule.getUID(), (Object)e);
        }
    }

    protected void onRemoveElement(Rule rule) {
        String uid = rule.getUID();
        if (this.ruleEngine.removeRule(uid)) {
            this.postEvent((Event)RuleEventFactory.createRuleRemovedEvent((Rule)rule, (String)SOURCE));
        }
        if (this.disabledRulesStorage != null) {
            this.disabledRulesStorage.remove(uid);
        }
        super.onRemoveElement((Object)rule);
    }

    protected void onUpdateElement(Rule oldElement, Rule element) throws IllegalArgumentException {
        this.postEvent((Event)RuleEventFactory.createRuleUpdatedEvent((Rule)element, (Rule)oldElement, (String)SOURCE));
        String rUID = element.getUID();
        if (this.disabledRulesStorage != null && this.disabledRulesStorage.get(rUID) != null) {
            this.ruleEngine.setRuleEnabled(rUID, false);
        }
        this.ruleEngine.updateRule(element);
    }

    public Rule get(String key) {
        return this.ruleEngine.getRule(key);
    }

    public Collection<Rule> getByTag(String tag) {
        return this.ruleEngine.getRulesByTag(tag);
    }

    public Collection<Rule> getByTags(Set<String> tags) {
        return this.ruleEngine.getRulesByTags(tags);
    }

    public synchronized void setEnabled(String uid, boolean isEnabled) {
        this.ruleEngine.setRuleEnabled(uid, isEnabled);
        if (this.disabledRulesStorage != null) {
            if (isEnabled) {
                this.disabledRulesStorage.remove(uid);
            } else {
                this.disabledRulesStorage.put(uid, (Object)isEnabled);
            }
        }
    }

    public RuleStatusInfo getStatus(String ruleUID) {
        return this.ruleEngine.getRuleStatusInfo(ruleUID);
    }

    protected void setDisabledRuleStorage(Storage<Boolean> disabledRulesStorage) {
        this.disabledRulesStorage = disabledRulesStorage;
        for (Rule rule : this.ruleEngine.getRules()) {
            String uid = rule.getUID();
            if (this.ruleEngine.getRuleStatus(uid).equals((Object)RuleStatus.DISABLED)) {
                disabledRulesStorage.put(uid, (Object)false);
                continue;
            }
            disabledRulesStorage.remove(uid);
        }
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
    }

    public void statusInfoChanged(String ruleUID, RuleStatusInfo statusInfo) {
        this.postEvent((Event)RuleEventFactory.createRuleStatusInfoEvent((RuleStatusInfo)statusInfo, (String)ruleUID, (String)SOURCE));
    }

    public Boolean isEnabled(String ruleUID) {
        if (this.disabledRulesStorage != null && this.disabledRulesStorage.get(ruleUID) != null) {
            return Boolean.FALSE;
        }
        return this.ruleEngine.hasRule(ruleUID) ? Boolean.valueOf(!this.ruleEngine.getRuleStatus(ruleUID).equals((Object)RuleStatus.DISABLED)) : null;
    }

    public void dispose() {
    }
}

