/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.ReferenceResolverUtil;
import org.eclipse.smarthome.automation.core.internal.RuntimeAction;
import org.eclipse.smarthome.automation.core.internal.RuntimeCondition;
import org.eclipse.smarthome.automation.core.internal.RuntimeTrigger;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;

public class RuntimeRule
extends Rule {
    private static final char REFERENCE_SYMBOL = '$';
    private Map<String, Module> moduleMap;

    public RuntimeRule(String ruleTemplateUID, Map<String, ?> configurations) {
        super(ruleTemplateUID, configurations);
    }

    public RuntimeRule(Rule rule, RuleTemplate template) {
        super(rule.getUID(), RuntimeRule.getRuntimeTriggersCopy(template.getTriggers()), RuntimeRule.getRuntimeConditionsCopy(template.getConditions()), RuntimeRule.getRuntimeActionsCopy(template.getActions()), null, null, template.getVisibility());
        this.validateConfiguration(template.getConfigurationDescription(), rule.getConfiguration());
        this.setName(rule.getName());
        this.setTags(template.getTags());
        this.setDescription(template.getDescription());
    }

    protected RuntimeRule(Rule rule) {
        super(rule.getUID(), RuntimeRule.getRuntimeTriggersCopy(rule.getTriggers()), RuntimeRule.getRuntimeConditionsCopy(rule.getConditions()), RuntimeRule.getRuntimeActionsCopy(rule.getActions()), rule.getConfigurationDescriptions(), rule.getConfiguration(), rule.getTemplateUID(), rule.getVisibility());
        this.setName(rule.getName());
        this.setTags(rule.getTags());
        this.setDescription(rule.getDescription());
    }

    public void setConfiguration(Map<String, ?> ruleConfiguration) {
        this.configuration = ruleConfiguration != null ? new HashMap(ruleConfiguration) : new HashMap(11);
    }

    public Module getModule(String moduleId) {
        if (this.moduleMap == null) {
            this.moduleMap = this.initModuleMap();
        }
        return this.moduleMap.get(moduleId);
    }

    private Map<String, Module> initModuleMap() {
        this.moduleMap = new HashMap<String, Module>(20);
        for (Module m : this.getTriggers()) {
            this.moduleMap.put(m.getId(), m);
        }
        for (Module m : this.getConditions()) {
            this.moduleMap.put(m.getId(), m);
        }
        for (Module m : this.getActions()) {
            this.moduleMap.put(m.getId(), m);
        }
        return this.moduleMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RuntimeRule && this.getUID() != null) {
            RuntimeRule r = (RuntimeRule)((Object)obj);
            return this.getUID().equals(r.getUID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getUID() != null) {
            return this.getUID().hashCode();
        }
        return super.hashCode();
    }

    private void validateConfiguration0(List<ConfigDescriptionParameter> configDescriptions, Map<String, Object> configurations) {
        if (configurations == null || configurations.isEmpty()) {
            if (this.isOptionalConfig(configDescriptions)) {
                return;
            }
            throw new IllegalArgumentException("Missing required configuration properties!");
        }
        for (ConfigDescriptionParameter configParameter : configDescriptions) {
            String configParameterName = configParameter.getName();
            this.processValue(configurations.remove(configParameterName), configParameter);
        }
        if (!configurations.isEmpty()) {
            String msg = "\"";
            Iterator<ConfigDescriptionParameter> i = configDescriptions.iterator();
            while (i.hasNext()) {
                ConfigDescriptionParameter configParameter = i.next();
                msg = i.hasNext() ? String.valueOf(msg) + configParameter.getName() + "\", " : String.valueOf(msg) + configParameter.getName();
            }
            throw new IllegalArgumentException("Extra configuration properties : " + msg + "\"!");
        }
    }

    private boolean isOptionalConfig(List<ConfigDescriptionParameter> configDescriptions) {
        if (configDescriptions != null && !configDescriptions.isEmpty()) {
            boolean required = false;
            for (ConfigDescriptionParameter param : configDescriptions) {
                boolean bl = required = required || param.isRequired();
            }
            return !required;
        }
        return true;
    }

    private void processValue(Object configValue, ConfigDescriptionParameter configParameter) {
        if (configValue != null) {
            this.checkType(configValue, configParameter);
            return;
        }
        if (configParameter.getDefault() != null) {
            return;
        }
        if (configParameter.isRequired()) {
            throw new IllegalArgumentException("Required configuration property missing: \"" + configParameter.getName() + "\"!");
        }
    }

    private void checkType(Object configValue, ConfigDescriptionParameter configParameter) {
        ConfigDescriptionParameter.Type type = configParameter.getType();
        if (configParameter.isMultiple().booleanValue()) {
            if (configValue instanceof List) {
                List lConfigValues = (List)configValue;
                for (Object value : lConfigValues) {
                    if (this.checkType(type, value)) continue;
                    throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected type: " + type);
                }
            }
            throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected is Array with type for elements : " + type.toString() + "!");
        }
        if (!this.checkType(type, configValue)) {
            throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected is " + type.toString() + "!");
        }
    }

    private boolean checkType(ConfigDescriptionParameter.Type type, Object configValue) {
        switch (type) {
            case TEXT: {
                return configValue instanceof String;
            }
            case BOOLEAN: {
                return configValue instanceof Boolean;
            }
            case INTEGER: {
                return configValue instanceof BigDecimal || configValue instanceof Integer || configValue instanceof Double && (double)((Double)configValue).intValue() == (Double)configValue;
            }
            case DECIMAL: {
                return configValue instanceof BigDecimal || configValue instanceof Double;
            }
        }
        return false;
    }

    private void validateConfiguration(List<ConfigDescriptionParameter> configDescriptions, Map<String, ?> ruleConfiguration) {
        if (ruleConfiguration != null) {
            this.validateConfiguration0(configDescriptions, new HashMap<String, Object>(ruleConfiguration));
            this.handleModuleConfigReferences(this.getTriggers(), ruleConfiguration);
            this.handleModuleConfigReferences(this.getConditions(), ruleConfiguration);
            this.handleModuleConfigReferences(this.getActions(), ruleConfiguration);
        }
    }

    private void handleModuleConfigReferences(List<? extends Module> modules, Map<String, ?> ruleConfiguration) {
        if (modules != null) {
            for (Module module : modules) {
                ReferenceResolverUtil.updateModuleConfiguration(module, ruleConfiguration);
            }
        }
    }

    protected void setUID(String rUID) {
        this.uid = rUID;
    }

    private static List<Action> getActionsCopy(List<Action> actions) {
        ArrayList<Action> res = new ArrayList<Action>();
        if (actions != null) {
            for (Action a : actions) {
                Action action = new Action(a.getId(), a.getTypeUID(), a.getConfiguration(), a.getInputs());
                action.setLabel(a.getLabel());
                action.setDescription(a.getDescription());
                res.add(action);
            }
        }
        return res;
    }

    private static List<Action> getRuntimeActionsCopy(List<Action> actions) {
        ArrayList<Action> res = new ArrayList<Action>();
        if (actions != null) {
            for (Action action : actions) {
                res.add(new RuntimeAction(action));
            }
        }
        return res;
    }

    private static List<Condition> getConditionsCopy(List<Condition> conditions) {
        ArrayList<Condition> res = new ArrayList<Condition>(11);
        if (conditions != null) {
            for (Condition c : conditions) {
                Condition condition = new Condition(c.getId(), c.getTypeUID(), c.getConfiguration(), c.getInputs());
                condition.setLabel(c.getLabel());
                condition.setDescription(c.getDescription());
                res.add(condition);
            }
        }
        return res;
    }

    private static List<Condition> getRuntimeConditionsCopy(List<Condition> conditions) {
        ArrayList<Condition> res = new ArrayList<Condition>(11);
        if (conditions != null) {
            for (Condition condition : conditions) {
                res.add(new RuntimeCondition(condition));
            }
        }
        return res;
    }

    private static List<Trigger> getTriggersCopy(List<Trigger> triggers) {
        ArrayList<Trigger> res = new ArrayList<Trigger>(11);
        if (triggers != null) {
            for (Trigger t : triggers) {
                Trigger trigger = new Trigger(t.getId(), t.getTypeUID(), t.getConfiguration());
                trigger.setLabel(t.getLabel());
                trigger.setDescription(t.getDescription());
                res.add(trigger);
            }
        }
        return res;
    }

    private static List<Trigger> getRuntimeTriggersCopy(List<Trigger> triggers) {
        ArrayList<Trigger> res = new ArrayList<Trigger>(11);
        if (triggers != null) {
            for (Trigger trigger : triggers) {
                res.add(new RuntimeTrigger(trigger));
            }
        }
        return res;
    }

    protected Rule getRuleCopy() {
        Rule rule = new Rule(this.getUID(), RuntimeRule.getTriggersCopy(this.getTriggers()), RuntimeRule.getConditionsCopy(this.getConditions()), RuntimeRule.getActionsCopy(this.getActions()), this.getConfigurationDescriptions(), this.getConfiguration(), this.getTemplateUID(), this.getVisibility());
        rule.setName(this.getName());
        rule.setTags(this.getTags());
        rule.setDescription(this.getDescription());
        return rule;
    }
}

