/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.composite;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.ReferenceResolverUtil;
import org.eclipse.smarthome.automation.core.internal.RuleEngine;
import org.eclipse.smarthome.automation.core.internal.composite.AbstractCompositeModuleHandler;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeActionHandler;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeConditionHandler;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeTriggerHandler;
import org.eclipse.smarthome.automation.core.internal.type.ModuleTypeManager;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeModuleHandlerFactory
extends BaseModuleHandlerFactory
implements ModuleHandlerFactory {
    private ModuleTypeManager mtManager;
    private RuleEngine ruleEngine;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public CompositeModuleHandlerFactory(BundleContext bc, ModuleTypeManager mtManager, RuleEngine re) {
        this.mtManager = mtManager;
        this.ruleEngine = re;
        this.activate(bc);
    }

    public Collection<String> getTypes() {
        return null;
    }

    public void ungetHandler(Module module, String ruleUID, ModuleHandler handler) {
        ModuleHandler handlerOfModule = (ModuleHandler)this.handlers.get(String.valueOf(ruleUID) + module.getId());
        if (handlerOfModule instanceof AbstractCompositeModuleHandler) {
            AbstractCompositeModuleHandler h = (AbstractCompositeModuleHandler)handlerOfModule;
            Set modules = h.moduleHandlerMap.keySet();
            if (modules != null) {
                for (Module child : modules) {
                    ModuleHandler childHandler = (ModuleHandler)h.moduleHandlerMap.get(child);
                    ModuleHandlerFactory mhf = this.ruleEngine.getModuleHandlerFactory(child.getTypeUID(), ruleUID);
                    mhf.ungetHandler(child, ruleUID, childHandler);
                }
            }
        }
        super.ungetHandler(module, ruleUID, handler);
    }

    public ModuleHandler internalCreate(Module module, String ruleUID) {
        AbstractCompositeModuleHandler handler = null;
        if (module != null) {
            this.logger.debug("create composite module:" + module + ", of rule: " + ruleUID);
            String moduleType = module.getTypeUID();
            Object mt = this.mtManager.get(moduleType);
            if (mt instanceof CompositeTriggerType) {
                List childModules = ((CompositeTriggerType)mt).getChildren();
                LinkedHashMap<Trigger, TriggerHandler> mapModuleToHandler = this.getChildHandlers(module.getConfiguration(), childModules, ruleUID);
                if (mapModuleToHandler != null) {
                    handler = new CompositeTriggerHandler((Trigger)module, (CompositeTriggerType)mt, mapModuleToHandler, ruleUID);
                }
            } else if (mt instanceof CompositeConditionType) {
                List childModules = ((CompositeConditionType)mt).getChildren();
                LinkedHashMap<Condition, ConditionHandler> mapModuleToHandler = this.getChildHandlers(module.getConfiguration(), childModules, ruleUID);
                if (mapModuleToHandler != null) {
                    handler = new CompositeConditionHandler((Condition)module, (CompositeConditionType)mt, mapModuleToHandler, ruleUID);
                }
            } else if (mt instanceof CompositeActionType) {
                List childModules = ((CompositeActionType)mt).getChildren();
                LinkedHashMap<Action, ActionHandler> mapModuleToHandler = this.getChildHandlers(module.getConfiguration(), childModules, ruleUID);
                if (mapModuleToHandler != null) {
                    handler = new CompositeActionHandler((Action)module, (CompositeActionType)mt, mapModuleToHandler, ruleUID);
                }
            }
        }
        this.logger.debug("Set handler to composite module:" + module + " -> " + handler);
        return handler;
    }

    private <T extends Module, MT extends ModuleHandler> LinkedHashMap<T, MT> getChildHandlers(Map<String, Object> compositeConfig, List<T> childModules, String ruleUID) {
        LinkedHashMap<Module, ModuleHandler> mapModuleToHandler = new LinkedHashMap<Module, ModuleHandler>();
        for (Module child : childModules) {
            this.ruleEngine.updateMapModuleTypeToRule(ruleUID, child.getTypeUID());
            ModuleHandlerFactory childMhf = this.ruleEngine.getModuleHandlerFactory(child.getTypeUID(), ruleUID);
            if (childMhf == null) {
                mapModuleToHandler.clear();
                mapModuleToHandler = null;
                return null;
            }
            ReferenceResolverUtil.updateModuleConfiguration(child, compositeConfig);
            ModuleHandler childHandler = childMhf.getHandler(child, ruleUID);
            if (childHandler == null) {
                mapModuleToHandler.clear();
                mapModuleToHandler = null;
                return null;
            }
            mapModuleToHandler.put(child, childHandler);
        }
        return mapModuleToHandler;
    }

    private void resolveConfigurationProperties(Map<String, Object> compositeConfig, Module child) {
        Map childConfig = child.getConfiguration();
        for (Map.Entry entry : childConfig.entrySet()) {
            Object o;
            String ref;
            Object value = entry.getValue();
            if (value == null || !(value instanceof String) || !(ref = (String)value).startsWith("$") || ref.length() <= 1 || (o = compositeConfig.get(ref = ref.substring(1))) == null) continue;
            entry.setValue(o);
        }
    }

    public void dispose() {
        super.dispose();
        this.mtManager = null;
        this.ruleEngine = null;
    }
}

